package com.xforceplus.ant.coop.rule.center.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsConfigTemialQueryMakeOutRequest
 */

@JsonInclude(NON_NULL)
public class MsConfigTemialQueryMakeOutRequest {
  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonProperty("opTenantId")
  private Long opTenantId = null;

  @JsonProperty("inputTerminalIds")
  private String inputTerminalIds = null;

  @JsonProperty("inputTerminalUns")
  private String inputTerminalUns = null;

  @JsonProperty("inputDeviceIds")
  private String inputDeviceIds = null;

  @JsonProperty("inputDeviceUns")
  private String inputDeviceUns = null;

  @JsonProperty("terminalInfo")
  private MsTerminalQueryInfo terminalInfo = null;

  @JsonIgnore
  public MsConfigTemialQueryMakeOutRequest opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作人ID
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作人ID")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsConfigTemialQueryMakeOutRequest opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作人姓名
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作人姓名")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }

  @JsonIgnore
  public MsConfigTemialQueryMakeOutRequest opTenantId(Long opTenantId) {
    this.opTenantId = opTenantId;
    return this;
  }

   /**
   * 操作租户ID
   * @return opTenantId
  **/
  @ApiModelProperty(value = "操作租户ID")
  public Long getOpTenantId() {
    return opTenantId;
  }

  public void setOpTenantId(Long opTenantId) {
    this.opTenantId = opTenantId;
  }

  @JsonIgnore
  public MsConfigTemialQueryMakeOutRequest inputTerminalIds(String inputTerminalIds) {
    this.inputTerminalIds = inputTerminalIds;
    return this;
  }

   /**
   * 待查询终端ID列表（以逗号隔开，非必输项）
   * @return inputTerminalIds
  **/
  @ApiModelProperty(value = "待查询终端ID列表（以逗号隔开，非必输项）")
  public String getInputTerminalIds() {
    return inputTerminalIds;
  }

  public void setInputTerminalIds(String inputTerminalIds) {
    this.inputTerminalIds = inputTerminalIds;
  }

  @JsonIgnore
  public MsConfigTemialQueryMakeOutRequest inputTerminalUns(String inputTerminalUns) {
    this.inputTerminalUns = inputTerminalUns;
    return this;
  }

   /**
   * 待查询终端UN列表（以逗号隔开，非必输项）
   * @return inputTerminalUns
  **/
  @ApiModelProperty(value = "待查询终端UN列表（以逗号隔开，非必输项）")
  public String getInputTerminalUns() {
    return inputTerminalUns;
  }

  public void setInputTerminalUns(String inputTerminalUns) {
    this.inputTerminalUns = inputTerminalUns;
  }

  @JsonIgnore
  public MsConfigTemialQueryMakeOutRequest inputDeviceIds(String inputDeviceIds) {
    this.inputDeviceIds = inputDeviceIds;
    return this;
  }

   /**
   * 待查询设备ID列表（以逗号隔开，非必输项）
   * @return inputDeviceIds
  **/
  @ApiModelProperty(value = "待查询设备ID列表（以逗号隔开，非必输项）")
  public String getInputDeviceIds() {
    return inputDeviceIds;
  }

  public void setInputDeviceIds(String inputDeviceIds) {
    this.inputDeviceIds = inputDeviceIds;
  }

  @JsonIgnore
  public MsConfigTemialQueryMakeOutRequest inputDeviceUns(String inputDeviceUns) {
    this.inputDeviceUns = inputDeviceUns;
    return this;
  }

   /**
   * 待查询设备UN列表（以逗号隔开，非必输项）
   * @return inputDeviceUns
  **/
  @ApiModelProperty(value = "待查询设备UN列表（以逗号隔开，非必输项）")
  public String getInputDeviceUns() {
    return inputDeviceUns;
  }

  public void setInputDeviceUns(String inputDeviceUns) {
    this.inputDeviceUns = inputDeviceUns;
  }

  @JsonIgnore
  public MsConfigTemialQueryMakeOutRequest terminalInfo(MsTerminalQueryInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
    return this;
  }

   /**
   * 终端信息
   * @return terminalInfo
  **/
  @ApiModelProperty(value = "终端信息")
  public MsTerminalQueryInfo getTerminalInfo() {
    return terminalInfo;
  }

  public void setTerminalInfo(MsTerminalQueryInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigTemialQueryMakeOutRequest configTemialQueryMakeOutRequest = (MsConfigTemialQueryMakeOutRequest) o;
    return Objects.equals(this.opUserId, configTemialQueryMakeOutRequest.opUserId) &&
        Objects.equals(this.opUserName, configTemialQueryMakeOutRequest.opUserName) &&
        Objects.equals(this.opTenantId, configTemialQueryMakeOutRequest.opTenantId) &&
        Objects.equals(this.inputTerminalIds, configTemialQueryMakeOutRequest.inputTerminalIds) &&
        Objects.equals(this.inputTerminalUns, configTemialQueryMakeOutRequest.inputTerminalUns) &&
        Objects.equals(this.inputDeviceIds, configTemialQueryMakeOutRequest.inputDeviceIds) &&
        Objects.equals(this.inputDeviceUns, configTemialQueryMakeOutRequest.inputDeviceUns) &&
        Objects.equals(this.terminalInfo, configTemialQueryMakeOutRequest.terminalInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(opUserId, opUserName, opTenantId, inputTerminalIds, inputTerminalUns, inputDeviceIds, inputDeviceUns, terminalInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigTemialQueryMakeOutRequest {\n");

    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("    opTenantId: ").append(toIndentedString(opTenantId)).append("\n");
    sb.append("    inputTerminalIds: ").append(toIndentedString(inputTerminalIds)).append("\n");
    sb.append("    inputTerminalUns: ").append(toIndentedString(inputTerminalUns)).append("\n");
    sb.append("    inputDeviceIds: ").append(toIndentedString(inputDeviceIds)).append("\n");
    sb.append("    inputDeviceUns: ").append(toIndentedString(inputDeviceUns)).append("\n");
    sb.append("    terminalInfo: ").append(toIndentedString(terminalInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
