package com.xforceplus.ant.coop.rule.center.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsConfigUpdateTerminalStatusRequest
 */

@JsonInclude(NON_NULL)
public class MsConfigUpdateTerminalStatusRequest {
  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonProperty("opTenantId")
  private Long opTenantId = null;

  @JsonProperty("terminalId")
  private List<Long> terminalId = new ArrayList<Long>();

  @JsonProperty("terminalUn")
  private List<String> terminalUn = new ArrayList<String>();

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("operateInfo")
  private MsOperateInfo operateInfo = null;

  @JsonProperty("licenseInfo")
  private MsLicenseInfo licenseInfo = null;

  @JsonIgnore
  public MsConfigUpdateTerminalStatusRequest opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作人ID
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作人ID")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsConfigUpdateTerminalStatusRequest opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作人姓名
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作人姓名")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }

  @JsonIgnore
  public MsConfigUpdateTerminalStatusRequest opTenantId(Long opTenantId) {
    this.opTenantId = opTenantId;
    return this;
  }

   /**
   * 操作租户ID
   * @return opTenantId
  **/
  @ApiModelProperty(value = "操作租户ID")
  public Long getOpTenantId() {
    return opTenantId;
  }

  public void setOpTenantId(Long opTenantId) {
    this.opTenantId = opTenantId;
  }

  @JsonIgnore
  public MsConfigUpdateTerminalStatusRequest terminalId(List<Long> terminalId) {
    this.terminalId = terminalId;
    return this;
  }

  public MsConfigUpdateTerminalStatusRequest addTerminalIdItem(Long terminalIdItem) {
    this.terminalId.add(terminalIdItem);
    return this;
  }

   /**
   * 终端id
   * @return terminalId
  **/
  @ApiModelProperty(value = "终端id")
  public List<Long> getTerminalId() {
    return terminalId;
  }

  public void setTerminalId(List<Long> terminalId) {
    this.terminalId = terminalId;
  }

  @JsonIgnore
  public MsConfigUpdateTerminalStatusRequest terminalUn(List<String> terminalUn) {
    this.terminalUn = terminalUn;
    return this;
  }

  public MsConfigUpdateTerminalStatusRequest addTerminalUnItem(String terminalUnItem) {
    this.terminalUn.add(terminalUnItem);
    return this;
  }

   /**
   * 终端联合id
   * @return terminalUn
  **/
  @ApiModelProperty(value = "终端联合id")
  public List<String> getTerminalUn() {
    return terminalUn;
  }

  public void setTerminalUn(List<String> terminalUn) {
    this.terminalUn = terminalUn;
  }

  @JsonIgnore
  public MsConfigUpdateTerminalStatusRequest companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司id，启用的时候需要传
   * @return companyId
  **/
  @ApiModelProperty(value = "公司id，启用的时候需要传")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsConfigUpdateTerminalStatusRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：停用 22：作废）
   * @return status
  **/
  @ApiModelProperty(value = "状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：停用 22：作废）")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsConfigUpdateTerminalStatusRequest operateInfo(MsOperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/
  @ApiModelProperty(value = "操作信息")
  public MsOperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(MsOperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }

  @JsonIgnore
  public MsConfigUpdateTerminalStatusRequest licenseInfo(MsLicenseInfo licenseInfo) {
    this.licenseInfo = licenseInfo;
    return this;
  }

   /**
   * 授权文件信息
   * @return licenseInfo
  **/
  @ApiModelProperty(value = "授权文件信息")
  public MsLicenseInfo getLicenseInfo() {
    return licenseInfo;
  }

  public void setLicenseInfo(MsLicenseInfo licenseInfo) {
    this.licenseInfo = licenseInfo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigUpdateTerminalStatusRequest configUpdateTerminalStatusRequest = (MsConfigUpdateTerminalStatusRequest) o;
    return Objects.equals(this.opUserId, configUpdateTerminalStatusRequest.opUserId) &&
        Objects.equals(this.opUserName, configUpdateTerminalStatusRequest.opUserName) &&
        Objects.equals(this.opTenantId, configUpdateTerminalStatusRequest.opTenantId) &&
        Objects.equals(this.terminalId, configUpdateTerminalStatusRequest.terminalId) &&
        Objects.equals(this.terminalUn, configUpdateTerminalStatusRequest.terminalUn) &&
        Objects.equals(this.companyId, configUpdateTerminalStatusRequest.companyId) &&
        Objects.equals(this.status, configUpdateTerminalStatusRequest.status) &&
        Objects.equals(this.operateInfo, configUpdateTerminalStatusRequest.operateInfo) &&
        Objects.equals(this.licenseInfo, configUpdateTerminalStatusRequest.licenseInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(opUserId, opUserName, opTenantId, terminalId, terminalUn, companyId, status, operateInfo, licenseInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigUpdateTerminalStatusRequest {\n");

    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("    opTenantId: ").append(toIndentedString(opTenantId)).append("\n");
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    terminalUn: ").append(toIndentedString(terminalUn)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("    licenseInfo: ").append(toIndentedString(licenseInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
