package com.xforceplus.ant.coop.rule.center.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 创建平台信息
 */
@ApiModel(description = "创建平台信息")

@JsonInclude(NON_NULL)
public class MsCreatePlatformRequest {
  @JsonProperty("source")
  private String source = null;

  @JsonProperty("platformName")
  private String platformName = null;

  @JsonProperty("restrictingAccess")
  private Integer restrictingAccess = null;

  @JsonProperty("whiteList")
  private List<String> whiteList = new ArrayList<String>();

  @JsonIgnore
  public MsCreatePlatformRequest source(String source) {
    this.source = source;
    return this;
  }

   /**
   * 平台来源
   * @return source
  **/
  @ApiModelProperty(value = "平台来源")
  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }

  @JsonIgnore
  public MsCreatePlatformRequest platformName(String platformName) {
    this.platformName = platformName;
    return this;
  }

   /**
   * 平台名称
   * @return platformName
  **/
  @ApiModelProperty(value = "平台名称")
  public String getPlatformName() {
    return platformName;
  }

  public void setPlatformName(String platformName) {
    this.platformName = platformName;
  }

  @JsonIgnore
  public MsCreatePlatformRequest restrictingAccess(Integer restrictingAccess) {
    this.restrictingAccess = restrictingAccess;
    return this;
  }

   /**
   * 访问限制  0-不限制(默认)  1-限制
   * @return restrictingAccess
  **/
  @ApiModelProperty(value = "访问限制  0-不限制(默认)  1-限制")
  public Integer getRestrictingAccess() {
    return restrictingAccess;
  }

  public void setRestrictingAccess(Integer restrictingAccess) {
    this.restrictingAccess = restrictingAccess;
  }

  @JsonIgnore
  public MsCreatePlatformRequest whiteList(List<String> whiteList) {
    this.whiteList = whiteList;
    return this;
  }

  public MsCreatePlatformRequest addWhiteListItem(String whiteListItem) {
    this.whiteList.add(whiteListItem);
    return this;
  }

   /**
   * 白名单列表（IP/域名）
   * @return whiteList
  **/
  @ApiModelProperty(value = "白名单列表（IP/域名）")
  public List<String> getWhiteList() {
    return whiteList;
  }

  public void setWhiteList(List<String> whiteList) {
    this.whiteList = whiteList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCreatePlatformRequest createPlatformRequest = (MsCreatePlatformRequest) o;
    return Objects.equals(this.source, createPlatformRequest.source) &&
        Objects.equals(this.platformName, createPlatformRequest.platformName) &&
        Objects.equals(this.restrictingAccess, createPlatformRequest.restrictingAccess) &&
        Objects.equals(this.whiteList, createPlatformRequest.whiteList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(source, platformName, restrictingAccess, whiteList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCreatePlatformRequest {\n");
    
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    platformName: ").append(toIndentedString(platformName)).append("\n");
    sb.append("    restrictingAccess: ").append(toIndentedString(restrictingAccess)).append("\n");
    sb.append("    whiteList: ").append(toIndentedString(whiteList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
