package com.xforceplus.ant.coop.rule.center.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 平台信息
 */
@ApiModel(description = "平台信息")

@JsonInclude(NON_NULL)
public class MsGetPlatformBySource {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("source")
  private String source = null;

  @JsonProperty("platformName")
  private String platformName = null;

  @JsonProperty("restrictingAccess")
  private Integer restrictingAccess = null;

  @JsonProperty("whiteList")
  private List<String> whiteList = new ArrayList<String>();

  @JsonProperty("defaultFlag")
  private Integer defaultFlag = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsGetPlatformBySource id(String id) {
    this.id = id;
    return this;
  }

   /**
   * 平台ID
   * @return id
  **/
  @ApiModelProperty(value = "平台ID")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  @JsonIgnore
  public MsGetPlatformBySource source(String source) {
    this.source = source;
    return this;
  }

   /**
   * 平台来源
   * @return source
  **/
  @ApiModelProperty(value = "平台来源")
  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }

  @JsonIgnore
  public MsGetPlatformBySource platformName(String platformName) {
    this.platformName = platformName;
    return this;
  }

   /**
   * 平台名称
   * @return platformName
  **/
  @ApiModelProperty(value = "平台名称")
  public String getPlatformName() {
    return platformName;
  }

  public void setPlatformName(String platformName) {
    this.platformName = platformName;
  }

  @JsonIgnore
  public MsGetPlatformBySource restrictingAccess(Integer restrictingAccess) {
    this.restrictingAccess = restrictingAccess;
    return this;
  }

   /**
   * 访问限制  0-不限制(默认)  1-限制
   * @return restrictingAccess
  **/
  @ApiModelProperty(value = "访问限制  0-不限制(默认)  1-限制")
  public Integer getRestrictingAccess() {
    return restrictingAccess;
  }

  public void setRestrictingAccess(Integer restrictingAccess) {
    this.restrictingAccess = restrictingAccess;
  }

  @JsonIgnore
  public MsGetPlatformBySource whiteList(List<String> whiteList) {
    this.whiteList = whiteList;
    return this;
  }

  public MsGetPlatformBySource addWhiteListItem(String whiteListItem) {
    this.whiteList.add(whiteListItem);
    return this;
  }

   /**
   * 白名单列表（IP/域名）
   * @return whiteList
  **/
  @ApiModelProperty(value = "白名单列表（IP/域名）")
  public List<String> getWhiteList() {
    return whiteList;
  }

  public void setWhiteList(List<String> whiteList) {
    this.whiteList = whiteList;
  }

  @JsonIgnore
  public MsGetPlatformBySource defaultFlag(Integer defaultFlag) {
    this.defaultFlag = defaultFlag;
    return this;
  }

   /**
   * 默认配置标 0-不是默认配置(默认) 1-默认配置
   * @return defaultFlag
  **/
  @ApiModelProperty(value = "默认配置标 0-不是默认配置(默认) 1-默认配置")
  public Integer getDefaultFlag() {
    return defaultFlag;
  }

  public void setDefaultFlag(Integer defaultFlag) {
    this.defaultFlag = defaultFlag;
  }

  @JsonIgnore
  public MsGetPlatformBySource status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 平台状态  0-启用(默认)  1-停用
   * @return status
  **/
  @ApiModelProperty(value = "平台状态  0-启用(默认)  1-停用")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsGetPlatformBySource createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsGetPlatformBySource updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetPlatformBySource getPlatformBySource = (MsGetPlatformBySource) o;
    return Objects.equals(this.id, getPlatformBySource.id) &&
        Objects.equals(this.source, getPlatformBySource.source) &&
        Objects.equals(this.platformName, getPlatformBySource.platformName) &&
        Objects.equals(this.restrictingAccess, getPlatformBySource.restrictingAccess) &&
        Objects.equals(this.whiteList, getPlatformBySource.whiteList) &&
        Objects.equals(this.defaultFlag, getPlatformBySource.defaultFlag) &&
        Objects.equals(this.status, getPlatformBySource.status) &&
        Objects.equals(this.createTime, getPlatformBySource.createTime) &&
        Objects.equals(this.updateTime, getPlatformBySource.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, source, platformName, restrictingAccess, whiteList, defaultFlag, status, createTime, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetPlatformBySource {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    platformName: ").append(toIndentedString(platformName)).append("\n");
    sb.append("    restrictingAccess: ").append(toIndentedString(restrictingAccess)).append("\n");
    sb.append("    whiteList: ").append(toIndentedString(whiteList)).append("\n");
    sb.append("    defaultFlag: ").append(toIndentedString(defaultFlag)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
