package com.xforceplus.ant.coop.rule.center.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.coop.rule.center.client.model.MsGetPlatformResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取平台信息返回
 */
@ApiModel(description = "获取平台信息返回")

@JsonInclude(NON_NULL)
public class MsGetPlatformResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private MsGetPlatformResult result = null;

  @JsonIgnore
  public MsGetPlatformResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 状态 其他-失败 1-成功
   * @return code
  **/
  @ApiModelProperty(value = "状态 其他-失败 1-成功")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsGetPlatformResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * 返回消息描述
   * @return message
  **/
  @ApiModelProperty(value = "返回消息描述")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsGetPlatformResponse result(MsGetPlatformResult result) {
    this.result = result;
    return this;
  }

   /**
   * Get result
   * @return result
  **/
  @ApiModelProperty(value = "")
  public MsGetPlatformResult getResult() {
    return result;
  }

  public void setResult(MsGetPlatformResult result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetPlatformResponse getPlatformResponse = (MsGetPlatformResponse) o;
    return Objects.equals(this.code, getPlatformResponse.code) &&
        Objects.equals(this.message, getPlatformResponse.message) &&
        Objects.equals(this.result, getPlatformResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetPlatformResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
