package com.xforceplus.ant.coop.rule.center.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 平台服务调用 信息
 */
@ApiModel(description = "平台服务调用 信息")

@JsonInclude(NON_NULL)
public class MsGetPlatformServerCall {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("serverId")
  private String serverId = null;

  @JsonProperty("serverClass")
  private String serverClass = null;

  @JsonIgnore
  public MsGetPlatformServerCall id(String id) {
    this.id = id;
    return this;
  }

   /**
   * 服务调用 数据ID
   * @return id
  **/
  @ApiModelProperty(value = "服务调用 数据ID")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  @JsonIgnore
  public MsGetPlatformServerCall serverId(String serverId) {
    this.serverId = serverId;
    return this;
  }

   /**
   * 服务ID
   * @return serverId
  **/
  @ApiModelProperty(value = "服务ID")
  public String getServerId() {
    return serverId;
  }

  public void setServerId(String serverId) {
    this.serverId = serverId;
  }

  @JsonIgnore
  public MsGetPlatformServerCall serverClass(String serverClass) {
    this.serverClass = serverClass;
    return this;
  }

   /**
   * 服务分类
   * @return serverClass
  **/
  @ApiModelProperty(value = "服务分类")
  public String getServerClass() {
    return serverClass;
  }

  public void setServerClass(String serverClass) {
    this.serverClass = serverClass;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetPlatformServerCall getPlatformServerCall = (MsGetPlatformServerCall) o;
    return Objects.equals(this.id, getPlatformServerCall.id) &&
        Objects.equals(this.serverId, getPlatformServerCall.serverId) &&
        Objects.equals(this.serverClass, getPlatformServerCall.serverClass);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, serverId, serverClass);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetPlatformServerCall {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    serverId: ").append(toIndentedString(serverId)).append("\n");
    sb.append("    serverClass: ").append(toIndentedString(serverClass)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
