package com.xforceplus.ant.coop.rule.center.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 库存信息
 */
@ApiModel(description = "库存信息")

@JsonInclude(NON_NULL)
public class MsStockInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("stockNum")
  private Integer stockNum = null;

  @JsonIgnore
  public MsStockInfo stockNum(Integer stockNum) {
    this.stockNum = stockNum;
    return this;
  }

   /**
   * 剩余库存数
   * @return stockNum
  **/


  @ApiModelProperty(value = "剩余库存数")
  public Integer getStockNum() {
    return stockNum;
  }

  public void setStockNum(Integer stockNum) {
    this.stockNum = stockNum;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsStockInfo stockInfo = (MsStockInfo) o;
    return Objects.equals(this.stockNum, stockInfo.stockNum);
  }

  @Override
  public int hashCode() {
    return Objects.hash(stockNum);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsStockInfo {\n");

    sb.append("    stockNum: ").append(toIndentedString(stockNum)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
