package com.xforceplus.ant.coop.rule.center.client.utils;

import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

public class ValidBean {
  private List<ValidField> validFieldList = new ArrayList<>();

  public ValidBean addField(ValidField validField){
    this.validFieldList.add(validField);
    return this;
  }

  public List<ValidField> getValidFieldList() {
    return validFieldList;
  }

  public void setValidFieldList(List<ValidField> validFieldList) {
    this.validFieldList = validFieldList;
  }

  /**
   * 执行校验逻辑
   * @return 校验通过返回：OK   否则返回具体错误信息
   */
  public String valid(){
    if (CollectionUtils.isEmpty(validFieldList)){
      return ValidField.VALID_OK;
    }
    String validResult = null;
    for (ValidField validField : validFieldList){
      validResult = validField.isValidOK();
      if (ValidField.VALID_OK.equals(validResult)){
        continue;
      }else {
        return validResult;
      }
    }
    return ValidField.VALID_OK;
  }
}
