package com.xforceplus.ant.coop.rule.center.client.utils;

import org.apache.commons.lang3.StringUtils;

public class ValidField {
  public static final String VALID_OK = "OK";
  /** 1-校验不为空 **/
  public static final int NOT_NULL=1;
  /** 5-校验不为NULL或空串 **/
  public static final int NOT_BLANK=5;
  /** 2-校验值范围 **/
  public static final int INCLUDE=2;
  /** 3-校验字符最大长度 **/
  public static final int MAX_LEN=3;
  /** 4-校验字符符合正则表达 **/
  public static final int MATCH_REGEX=4;
  private String fieldName;
  private Object fieldValue;
  /** 1-校验不为空  2-校验值范围  3-校验字符最大长度 4-校验字符符合正则表达 **/
  private int validType;
  /** 用于校验String类型字段的最大长度 **/
  private int maxLen;
  /** 用于校验字符串是否符合正则表达式 **/
  private String regex;
  private Object[] validValues;

  public ValidField(){
  }
  public ValidField(String fieldName, Object fieldValue, int validType){
    this.fieldName = fieldName;
    this.fieldValue = fieldValue;
    this.validType = validType;
  }
  public ValidField(String fieldName, String fieldValue, int validType, int maxLen){
     this(fieldName,fieldValue,validType);
     this.maxLen = maxLen;
  }
  public ValidField(String fieldName, String fieldValue, int validType, String regex){
     this(fieldName,fieldValue,validType);
     this.regex = regex;
  }

  public ValidField(String fieldName, Object fieldValue, int validType, Object[] validValues){
    this(fieldName,fieldValue,validType);
    this.validValues = validValues;
  }

  /**
   * 执行校验逻辑
   * @return 验通过返回：OK   否则返回具体错误信息
   */
  public String isValidOK(){
    switch (validType){
      case NOT_NULL:
        //校验不为空
        return fieldValue == null ? "字段["+fieldName+"]不能为空":VALID_OK;
      case NOT_BLANK:
        //校验不为NULL或空串
        return StringUtils.isBlank((String)fieldValue) ? "字段["+fieldName+"]不能为空":VALID_OK;
      case INCLUDE:
        //校验包涵值范围
        if (fieldValue == null){
          return "字段["+fieldName+"]不能为空";
        }
        for (Object validValue : validValues){
          if (fieldValue.equals(validValue) ){
            return VALID_OK;
          }
        }
        return "字段["+fieldName+"]传入值非法";
      case MAX_LEN:
        //校验字符最大长度
        if (fieldValue == null){
          return VALID_OK;
        }
        if (fieldValue instanceof String){
          int fieldLen = ((String)fieldValue).length();
          return maxLen >= fieldLen ? VALID_OK:"字段["+fieldName+"]超过最大长度["+maxLen+"]";
        }
        return VALID_OK;
      case MATCH_REGEX:
        //校验字符是否匹配正则表达式
        if (fieldValue == null){
          return VALID_OK;
        }
        if (fieldValue instanceof String){
          String fieldStr = (String)fieldValue;
          if (StringUtils.isEmpty(fieldStr)){
            return VALID_OK;
          }
          return fieldStr.matches(regex) ? VALID_OK:"字段["+fieldName+"]不合法";
        }
        return VALID_OK;
      default:
        break;
    }
    return VALID_OK;
  }
  public String getFieldName() {
    return fieldName;
  }

  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }

  public Object getFieldValue() {
    return fieldValue;
  }

  public void setFieldValue(Object fieldValue) {
    this.fieldValue = fieldValue;
  }

  public int getValidType() {
    return validType;
  }

  public void setValidType(int validType) {
    this.validType = validType;
  }

  public Object[] getValidValues() {
    return validValues;
  }

  public void setValidValues(Object[] validValues) {
    this.validValues = validValues;
  }

  public int getMaxLen() {
    return maxLen;
  }

  public void setMaxLen(int maxLen) {
    this.maxLen = maxLen;
  }
}
