/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.coop.rule.center.client.data.cc.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.ant.coop.rule.center.client.api.cc.TemplateCommonConfigApi;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit.DefaultValueLimit;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit.FieldLimit;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit.FixedEnumValueLimit;
import com.xforceplus.ant.coop.rule.center.client.data.cc.enums.FieldLimitEnum;
import com.xforceplus.ant.coop.rule.center.client.data.cc.enums.FixedEnumValueEnum;
import com.xforceplus.ant.coop.rule.center.client.data.cc.enums.LimitStatusEnum;
import com.xforceplus.ant.coop.rule.center.client.data.cc.exception.ValidateException;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.CheckInvalidCondition;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.RuleTemplateDetail;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.utils.FieldLimitUtils;
import com.xforceplus.ant.coop.rule.center.common.util.ReflectUtils;
import com.xforceplus.xplatframework.exception.ResultCode;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CommonConfigTool {
    private static final Logger log = LoggerFactory.getLogger(CommonConfigTool.class);

    public static boolean checkConditionExp(TemplateCommonConfigApi api, String exp, Map<String, Object> params) {
        CheckInvalidCondition condition = new CheckInvalidCondition();
        condition.setConditionExp(exp);
        condition.setParams(params);
        try {
            BaseResult<String> response = api.checkConditionExp(condition);
            log.info("##### \u6761\u4ef6\u8868\u8fbe\u5f0f\u6267\u884c \u54cd\u5e94\uff1a{}", (Object)JsonUtils.writeObjectToFastJson(response));
            return ResultCode.SUCCESS.code().equals(response.getCode());
        }
        catch (Exception e) {
            log.warn("##### \u6761\u4ef6\u8868\u8fbe\u5f0f\u6267\u884c\u5f02\u5e38\uff1a{}", (Throwable)e);
            return false;
        }
    }

    public static boolean checkInvalidCondition(TemplateCommonConfigApi api, FieldLimit fieldLimit, Map<String, Object> params) {
        if (null == ReflectUtils.getDeclaredMethod(fieldLimit, "getInvalidCondition") || null == ReflectUtils.getDeclaredMethod(fieldLimit, "getInvalidStatus")) {
            log.warn("##### fieldLimit:{}\uff1b\u4e0d\u5b58\u5728\u5931\u6548\u6761\u4ef6\uff1a", (Object)fieldLimit);
            return false;
        }
        Object invalidStatus = ReflectUtils.getValue(fieldLimit, "invalidStatus");
        if (null == invalidStatus || !LimitStatusEnum.ENABLED.code().equals(invalidStatus)) {
            log.info("##### fieldLimit:{}\uff1binvalidStatus is null/ invalidStatus \u5df2\u505c\u7528\uff1a", (Object)fieldLimit);
            return false;
        }
        Object invalidCondition = ReflectUtils.getValue(fieldLimit, "invalidCondition");
        if (null == invalidCondition || StringUtils.isEmpty((CharSequence)invalidCondition.toString())) {
            log.info("##### fieldLimit:{}\uff1binvalidCondition is null/\u4e3a\u7a7a\uff1a", (Object)fieldLimit);
            return false;
        }
        return CommonConfigTool.checkConditionExp(api, invalidCondition.toString(), params);
    }

    public static boolean checkLimitAntInvalidCondition(TemplateCommonConfigApi api, List<JSONObject> fieldLimits, FieldLimitEnum fieldLimitEnum, Map<String, Object> params) {
        boolean checkLimitAntStatus = CommonConfigTool.checkLimitAntStatus(fieldLimits, fieldLimitEnum);
        if (!checkLimitAntStatus) {
            return checkLimitAntStatus;
        }
        FieldLimit limit = (FieldLimit)FieldLimitUtils.getFieldLimitByJsonObjects(fieldLimits, fieldLimitEnum);
        return !CommonConfigTool.checkInvalidCondition(api, limit, params);
    }

    public static boolean checkLimitAntStatus(List<JSONObject> fieldLimits, FieldLimitEnum fieldLimitEnum) {
        Object limit = FieldLimitUtils.getFieldLimitByJsonObjects(fieldLimits, fieldLimitEnum);
        if (null == limit) {
            return false;
        }
        if (null != ReflectUtils.getDeclaredMethod(limit, "getStatus")) {
            Object status = ReflectUtils.getValue(limit, "status");
            return LimitStatusEnum.ENABLED.code().equals(status.toString());
        }
        return true;
    }

    public static LinkedHashMap<String, Object> validateNoEmpty(TemplateCommonConfigApi api, List<RuleTemplateDetail.ConfigItem> items, Map<String, Object> conditionParams) {
        return CommonConfigTool.validateNoEmpty(api, items, conditionParams, conditionParams, true);
    }

    public static LinkedHashMap<String, Object> validateNoEmpty(TemplateCommonConfigApi api, List<RuleTemplateDetail.ConfigItem> items, Map<String, Object> conditionParams, boolean throwException) {
        return CommonConfigTool.validateNoEmpty(api, items, conditionParams, conditionParams, throwException);
    }

    public static LinkedHashMap<String, Object> validateNoEmpty(TemplateCommonConfigApi api, List<RuleTemplateDetail.ConfigItem> items, Map<String, Object> validateFields, Map<String, Object> conditionParams) {
        return CommonConfigTool.validateNoEmpty(api, items, validateFields, conditionParams, true);
    }

    public static LinkedHashMap<String, Object> validateNoEmpty(TemplateCommonConfigApi api, List<RuleTemplateDetail.ConfigItem> items, Map<String, Object> validateFields, Map<String, Object> conditionParams, boolean throwException) {
        LinkedHashMap<String, Object> validateRs = new LinkedHashMap<String, Object>();
        if (CollectionUtils.isEmpty(items) || CollectionUtils.isEmpty(validateFields)) {
            return validateRs;
        }
        for (RuleTemplateDetail.ConfigItem item : items) {
            String fieldValue;
            if (!validateFields.containsKey(item.getFieldName()) || !CommonConfigTool.checkLimitAntInvalidCondition(api, item.getFieldLimits(), FieldLimitEnum.NO_EMPTY, conditionParams)) continue;
            Object valueObj = validateFields.get(item.getFieldName());
            if (null == valueObj) {
                String message = String.format("%s\u4e0d\u53ef\u4e3a\u7a7a", item.getFieldDisplayName());
                validateRs.put(item.getFieldName(), message);
                if (throwException) {
                    throw new ValidateException(message);
                }
            }
            if ((fieldValue = valueObj.toString()).startsWith("[") && fieldValue.endsWith("]")) {
                List fieldValues = JSON.parseArray((String)fieldValue, String.class);
                String string = fieldValue = CollectionUtils.isEmpty((Collection)fieldValues) ? "" : (String)fieldValues.get(0);
            }
            if (!StringUtils.isEmpty((CharSequence)fieldValue)) continue;
            String message = item.getFieldDisplayName() + "\u4e0d\u53ef\u4e3a\u7a7a";
            log.warn("##### \u6839\u636e\u6a21\u677f\u8fdb\u884c\u975e\u7a7a\u6821\u9a8c--\u6821\u9a8c\u672a\u901a\u8fc7\uff01 validateResult:{}", (Object)message);
            validateRs.put(item.getFieldName(), message);
            if (!throwException) continue;
            throw new ValidateException(message);
        }
        return validateRs;
    }

    public static void validateNoChangeFixedValue(TemplateCommonConfigApi api, List<RuleTemplateDetail.ConfigItem> items, Map<String, Object> conditionParams) {
        CommonConfigTool.validateNoChangeFixedValue(api, items, conditionParams, conditionParams);
    }

    public static void validateNoChangeFixedValue(TemplateCommonConfigApi api, List<RuleTemplateDetail.ConfigItem> items, Map<String, Object> validateFields, Map<String, Object> conditionParams) {
        if (CollectionUtils.isEmpty(items) || CollectionUtils.isEmpty(validateFields)) {
            return;
        }
        for (RuleTemplateDetail.ConfigItem item : items) {
            FixedEnumValueLimit fixedEnumValueLimit;
            if (!validateFields.containsKey(item.getFieldName())) continue;
            if (!CommonConfigTool.checkLimitAntInvalidCondition(api, item.getFieldLimits(), FieldLimitEnum.NO_CHANGE, conditionParams)) {
                log.info("##### \u5b57\u6bb5\u672a\u914d\u7f6e NoChange/\u5931\u6548\u6761\u4ef6\u6210\u7acb \u8df3\u8fc7\uff1a{}", (Object)JsonUtils.writeObjectToFastJson((Object)item));
                continue;
            }
            String fieldValue = null == validateFields.get(item.getFieldName()) ? null : validateFields.get(item.getFieldName()).toString();
            DefaultValueLimit defaultValueLimit = (DefaultValueLimit)FieldLimitUtils.getFieldLimitByJsonObjects(item.getFieldLimits(), FieldLimitEnum.DEFAULT_VALUE);
            if (null != defaultValueLimit && null != defaultValueLimit.getDefaultValue() && null != fieldValue) {
                log.info("#####\u6839\u636e\u6a21\u677f\u8fdb\u884c\u56fa\u5b9a\u503cNoChange\u6821\u9a8c-defaultValueLimit-\u5f00\u59cb\u6821\u9a8c modelField\uff1a{}", (Object)JSON.toJSONString((Object)item));
                if (fieldValue.startsWith("[") && fieldValue.endsWith("]")) {
                    List fieldValues = JSON.parseArray((String)fieldValue, String.class);
                    String string = fieldValue = CollectionUtils.isEmpty((Collection)fieldValues) ? "" : (String)fieldValues.get(0);
                }
                if (!defaultValueLimit.getDefaultValue().equals(fieldValue)) {
                    String message = item.getFieldDisplayName() + "\u503c[" + fieldValue + "]\u4e0e\u8d2d\u65b9\u914d\u7f6e\u56fa\u5b9a\u503c[" + defaultValueLimit.getDefaultValue() + "]\u4e0d\u4e00\u81f4";
                    log.info("\u6839\u636e\u6a21\u677f\u8fdb\u884c\u9ed8\u8ba4\u503cNoChange\u6821\u9a8c--\u6821\u9a8c\u672a\u901a\u8fc7\uff01 validateResult:{}", (Object)message);
                    throw new ValidateException(message);
                }
            }
            if (null == (fixedEnumValueLimit = (FixedEnumValueLimit)FieldLimitUtils.getFieldLimitByJsonObjects(item.getFieldLimits(), FieldLimitEnum.FIXED_ENUM_VALUE)) || !CollectionUtils.isEmpty(fixedEnumValueLimit.getEnumValues()) || null == fieldValue) continue;
            log.info("#####\u6839\u636e\u6a21\u677f\u8fdb\u884c\u56fa\u5b9a\u503cNoChange\u6821\u9a8c-fixedEnumValueLimit-\u5f00\u59cb\u6821\u9a8c modelField\uff1a{}", (Object)JSON.toJSONString((Object)item));
            List<FixedEnumValueLimit.FixedEnumValue> enumValues = fixedEnumValueLimit.getEnumValues();
            if (CollectionUtils.isEmpty(enumValues)) continue;
            List itemEnumValues = enumValues.stream().filter(v -> FixedEnumValueEnum.Y.code().equals(v.getFix())).map(FixedEnumValueLimit.FixedEnumValue::getCode).collect(Collectors.toList());
            List fieldValues = new ArrayList<String>();
            if (fieldValue.startsWith("[") && fieldValue.endsWith("]")) {
                fieldValues = JSON.parseArray((String)fieldValue, String.class);
            } else {
                fieldValues.add(fieldValue);
            }
            if (itemEnumValues.containsAll(fieldValues) && fieldValues.containsAll(itemEnumValues)) continue;
            String message = item.getFieldDisplayName() + "\u503c" + JSON.toJSONString(fieldValues) + "\u4e0e\u8d2d\u65b9\u914d\u7f6e\u56fa\u5b9a\u503c" + JSON.toJSONString(itemEnumValues) + "\u4e0d\u4e00\u81f4";
            log.warn("\u6839\u636e\u6a21\u677f\u8fdb\u884c\u56fa\u5b9a\u679a\u4e3e\u503cNoChange\u6821\u9a8c--\u6821\u9a8c\u672a\u901a\u8fc7\uff01 validateResult:{}", (Object)message);
            throw new ValidateException(message);
        }
    }
}

