/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.coop.rule.center.client.data.utils;

import com.xforceplus.xplatframework.exception.ResultCode;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

public class BaseResult<T>
implements Serializable {
    @ApiModelProperty(value="\u72b6\u6001\u7801")
    private Integer code;
    @ApiModelProperty(value="\u63d0\u793a\u4fe1\u606f")
    private String message;
    @ApiModelProperty(value="\u54cd\u5e94\u6570\u636e")
    private T result;
    @ApiModelProperty(value="\u8bf7\u6c42ID")
    private String requestId;
    public static final BaseResult<String> SUCCESS = new BaseResult(ResultCode.SUCCESS);

    public static BaseResult<String> success() {
        return new BaseResult<String>();
    }

    public static <T> BaseResult<T> success(T t) {
        return new BaseResult<T>(t);
    }

    public static BaseResult<String> error() {
        return new BaseResult<String>(ResultCode.SYSTEM_INNER_ERROR);
    }

    public static BaseResult<String> error(ResultCode resultCodeEnum) {
        return new BaseResult<String>(resultCodeEnum);
    }

    public static <T> BaseResult<T> fail(String message) {
        return new BaseResult<T>(message);
    }

    private BaseResult() {
        this(ResultCode.SUCCESS);
    }

    private BaseResult(T t) {
        this(ResultCode.SUCCESS, t);
    }

    private BaseResult(String message) {
        this(Response.Fail, message);
    }

    private BaseResult(ResultCode resultCode) {
        this(resultCode, null);
    }

    private BaseResult(ResultCode resultCode, T t) {
        this(resultCode.code(), resultCode.message(), t);
    }

    public BaseResult(int code, String message) {
        this(code, message, null);
    }

    private BaseResult(int code, String message, T t) {
        this.code = code;
        this.message = message;
        this.result = t;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getResult() {
        return this.result;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResult)) {
            return false;
        }
        BaseResult other = (BaseResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$result = this.getResult();
        T other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        return !(this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        return result;
    }

    public String toString() {
        return "BaseResult(code=" + this.getCode() + ", message=" + this.getMessage() + ", result=" + this.getResult() + ", requestId=" + this.getRequestId() + ")";
    }
}

