/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client.constant;

import java.util.stream.Stream;

public enum ConfigTypeEnum {
    SPLIT_CONFIG_TYPE(1, "\u62c6\u7968\u89c4\u5219", "invoiceSplitConfig"),
    MERGE_CONFIG_TYPE(2, "\u62c6\u5408\u89c4\u5219", "billMergeSplitConfig"),
    INVOICE_CONFIG_TYPE(3, "\u7968\u9762\u4fe1\u606f\u89c4\u5219", "invoiceInfoConfig"),
    INVOICE_USER_CONFIG_TYPE(4, "\u7968\u9762\u4eba\u5458\u89c4\u5219", "invoiceMemberInfoConfig"),
    PROCESS_CONFIG_TYPE(5, "\u4e1a\u52a1\u6d41\u7a0b\u89c4\u5219", "pageProcssConfig"),
    SYS_CONFIG_TYPE(6, "\u7cfb\u7edf\u89c4\u5219", "sysConfig"),
    BILL_MERGE_TYPE(7, "\u7ec4\u5408\u5408\u5e76\u89c4\u5219", "mergeRule"),
    BILL_INVOICE_MATCH_TYPE(8, "\u53d1\u7968\u5339\u914d\u4e1a\u52a1\u5355", "invoiceMatchConfig"),
    VIRTUAL_INVOICE_AUTO_TYPE(9, "\u865a\u62df\u53d1\u7968\u81ea\u52a8\u5f00\u5177\u81ea\u52a8\u7ea2\u51b2\u89c4\u5219", "virtualInvoiceAutoRule"),
    INVOICE_MAIL_RULE_CONFIG_TYPE(10, "\u53d1\u7968\u90ae\u4ef6\u63a8\u9001\u89c4\u5219", "invoiceMailRuleConfig"),
    UNKNOWN(0, "\u672a\u77e5\u89c4\u5219", "unknown");

    private Integer configType;
    private String configTypeDesc;
    private String objCode;

    private ConfigTypeEnum(Integer configType, String configTypeDesc, String objCode) {
        this.configType = configType;
        this.configTypeDesc = configTypeDesc;
        this.objCode = objCode;
    }

    public static ConfigTypeEnum of(Integer configType) {
        if (configType == null) {
            return UNKNOWN;
        }
        return Stream.of(ConfigTypeEnum.values()).filter(c -> c.configType == configType).findFirst().orElse(UNKNOWN);
    }

    public Integer getConfigType() {
        return this.configType;
    }

    public void setConfigType(Integer configType) {
        this.configType = configType;
    }

    public String getConfigTypeDesc() {
        return this.configTypeDesc;
    }

    public void setConfigTypeDesc(String configTypeDesc) {
        this.configTypeDesc = configTypeDesc;
    }

    public String getObjCode() {
        return this.objCode;
    }

    public void setObjCode(String objCode) {
        this.objCode = objCode;
    }

    public static ConfigTypeEnum getConfigTypeByValue(Integer configType) {
        ConfigTypeEnum[] configTypeEnums;
        for (ConfigTypeEnum tmp : configTypeEnums = ConfigTypeEnum.values()) {
            if (!tmp.getConfigType().equals(configType)) continue;
            return tmp;
        }
        return null;
    }
}

