/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.constant.PriceMethodTypeEnum;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.InvoiceSplitrRuleDTO;
import com.xforceplus.seller.invoice.client.model.PriceMethod;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InvoiceSplitParser
implements ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceSplitParser.class);

    @Override
    public InvoiceSplitrRuleDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        InvoiceSplitrRuleDTO invoiceSplitrRuleDTO = new InvoiceSplitrRuleDTO();
        for (MsConfigItemBean tmp : cfgConfigItemEntities) {
            logger.info("InvoiceSplitParse--parse--configId:{}", (Object)tmp.getConfigId());
            invoiceSplitrRuleDTO.setRuldId(tmp.getConfigId());
            String fieldName = tmp.getConfigItemName();
            ArrayList itemValueList = tmp.getConfigItemValue();
            if (CollectionUtils.isEmpty(itemValueList)) {
                logger.info("configId:{}--InvoiceSplitParse--parse--\u62c6\u5206\u914d\u7f6e\u9879\u503c\u8bbe\u7f6e\u9519\u8bef:null", (Object)tmp.getConfigId());
                itemValueList = Lists.newArrayList((Object[])new String[]{""});
            }
            String itemValue = itemValueList.get(0);
            logger.info("InvoiceSplitParser--fieldName:{} itemValuepars:{}", (Object)fieldName, (Object)itemValue);
            if ("invoiceLimit".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) {
                    throw new RuntimeException("\u5f00\u7968\u9650\u989d\u5fc5\u586b\u9879");
                }
                if (new BigDecimal(itemValue).compareTo(BigDecimal.ZERO) <= 0) {
                    throw new RuntimeException("\u5f00\u7968\u9650\u989d\u5fc5\u987b\u5927\u4e8e0");
                }
                invoiceSplitrRuleDTO.setInvoiceLimit(new BigDecimal(itemValue));
                continue;
            }
            if ("priceMethod".equals(fieldName)) {
                PriceMethodTypeEnum priceMethodTypeEnum;
                if (!NumberUtils.isNumber((String)itemValue)) {
                    itemValue = "0";
                    logger.info("\u4ef7\u683c\u65b9\u5f0f\uff1a0-\u4e0d\u542b\u7a0e 1-\u542b\u7a0e \u5f53\u524d\u4f20\u5165\u503c\u4e0d\u5728\u8303\u56f4\u5185.\u4f7f\u7528\u9ed8\u8ba4\u4ef7\u683c\u65b9\u5f0f\uff1a0-\u4e0d\u542b\u7a0e");
                }
                int priceMethod = (priceMethodTypeEnum = PriceMethodTypeEnum.fromValue(Integer.parseInt(itemValue))) == null ? 0 : priceMethodTypeEnum.getValue();
                PriceMethod priceMethodEnum = PriceMethod.value((Integer)priceMethod);
                invoiceSplitrRuleDTO.setPriceMethod(priceMethodEnum);
                continue;
            }
            if ("splitFiledList".equals(fieldName)) {
                invoiceSplitrRuleDTO.setSplitFiledList(itemValueList);
                continue;
            }
            if ("mergeBySplitField".equals(fieldName)) {
                Integer mergeBySplitField;
                if (!NumberUtils.isNumber((String)itemValue) || StringUtils.isEmpty((CharSequence)itemValue)) {
                    itemValue = "0";
                }
                if ((mergeBySplitField = Integer.valueOf(Integer.parseInt(itemValue))) < 0 || mergeBySplitField > 1) {
                    mergeBySplitField = 0;
                }
                invoiceSplitrRuleDTO.setMergeBySplitField(mergeBySplitField != 0);
                continue;
            }
            if ("saleListOption".equals(fieldName)) {
                invoiceSplitrRuleDTO.setSaleListOption(itemValue);
                continue;
            }
            if ("discountMode".equals(fieldName)) {
                invoiceSplitrRuleDTO.setDiscountMode(itemValue);
                continue;
            }
            if ("taxDeviceType".equals(fieldName)) {
                invoiceSplitrRuleDTO.setTaxDeviceType(itemValue);
                continue;
            }
            if ("itemSort".equals(fieldName)) {
                invoiceSplitrRuleDTO.setItemSort(itemValue);
                continue;
            }
            if ("salesListMaxRow".equals(fieldName)) {
                if (!Pattern.compile("^[\\d]*$").matcher(itemValue).matches()) {
                    logger.info("\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570\u53ea\u80fd\u4e3a\u6574\u6570\uff0c\u4f20\u5165\u503c\uff1a{}", (Object)itemValue);
                    throw new RuntimeException("\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570\u53ea\u80fd\u4e3a\u6574\u6570");
                }
                invoiceSplitrRuleDTO.setSalesListMaxRow(itemValue.equals("") ? 0 : Integer.parseInt(itemValue));
                continue;
            }
            if ("unitPriceAmountOps".equals(fieldName)) {
                invoiceSplitrRuleDTO.setUnitPriceAmountOps(itemValue);
                continue;
            }
            if ("amountSplitRule".equals(fieldName)) {
                invoiceSplitrRuleDTO.setAmountSplitRule(itemValue);
                continue;
            }
            if ("integerOps".equals(fieldName)) {
                invoiceSplitrRuleDTO.setIntegerOps(Boolean.parseBoolean(itemValue.equals("") ? "false" : itemValue));
                continue;
            }
            if ("invoiceItemMaxRow".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) {
                    throw new RuntimeException("\u7968\u9762\u884c\u6570\u5fc5\u586b\u9879");
                }
                if (new BigDecimal(itemValue).compareTo(BigDecimal.ZERO) <= 0) {
                    throw new RuntimeException("\u7968\u9762\u884c\u6570\u5fc5\u987b\u5927\u4e8e0");
                }
                invoiceSplitrRuleDTO.setInvoiceItemMaxRow(CommonTools.isEmpty((String)itemValue) ? 0 : Integer.parseInt(itemValue));
                continue;
            }
            if ("invoiceType".equals(fieldName)) {
                invoiceSplitrRuleDTO.setInvoiceType(itemValue);
                continue;
            }
            if ("invoiceRemarkFiledList".equals(fieldName)) {
                invoiceSplitrRuleDTO.setInvoiceRemarkFiledList(itemValueList);
                continue;
            }
            if ("invoiceItemRemarkFiledList".equals(fieldName)) {
                invoiceSplitrRuleDTO.setInvoiceItemRemarkFiledList(itemValueList);
                continue;
            }
            if ("goodsServicesNameFieldsList".equals(fieldName)) {
                invoiceSplitrRuleDTO.setGoodsServicesNameFieldsList(itemValueList);
                continue;
            }
            if ("itemSpecFieldsList".equals(fieldName)) {
                invoiceSplitrRuleDTO.setItemSpecFieldsList(itemValueList);
                continue;
            }
            if ("goodsServicesNameMainFieldsList".equals(fieldName)) {
                invoiceSplitrRuleDTO.setGoodsServicesNameMainFieldsList(itemValueList);
                continue;
            }
            if ("itemSpecMainFieldsList".equals(fieldName)) {
                invoiceSplitrRuleDTO.setItemSpecMainFieldsList(itemValueList);
                continue;
            }
            if ("customRemarkSize".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) continue;
                if (itemValue.matches("^-?\\d+$")) {
                    invoiceSplitrRuleDTO.setCustomRemarkSize(Integer.valueOf(itemValue));
                    continue;
                }
                throw new RuntimeException("\u81ea\u5b9a\u4e49\u5907\u6ce8\u957f\u5ea6\u5fc5\u987b\u4e3a\u6574\u6570");
            }
            if (!"bizBillDiscountRate".equals(fieldName)) continue;
            if (!CommonTools.isEmpty((String)itemValue)) {
                if (!itemValue.contains("%")) continue;
                itemValue = StringUtils.replace((String)itemValue, (String)"%", (String)"");
                invoiceSplitrRuleDTO.setBizBillDiscountRate(new BigDecimal(itemValue).divide(new BigDecimal("100")));
                continue;
            }
            invoiceSplitrRuleDTO.setBizBillDiscountRate(new BigDecimal(itemValue));
        }
        logger.info("parse end ======");
        return invoiceSplitrRuleDTO;
    }
}

