package com.xforceplus.seller.config.client;

import com.google.common.collect.Lists;
import com.xforceplus.seller.config.client.model.*;
import com.xforceplus.xplatframework.utils.JsonUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author zzw
 * @Description
 * @Date
 * @return
 *
 * 拆票规则装配
 **/
@Component
public class ItemAssemble {
     public MsConfigItemAddRequest convert2ConfigItemRequest(ConfigItemDTO configItemDTO) {
        MsConfigItemAddRequest msConfigItemAddRequest  = new MsConfigItemAddRequest();
         List<ItemDTO> itemDTOs =   configItemDTO.getItemList();
        List<MsConfigItemBean> cfgConfigItemEntities = itemDTOs.stream()
                .filter(Objects::nonNull)
                .map(this::ItemDtoConvert2ConfigItemBean)
                .collect(Collectors.toList());
        msConfigItemAddRequest.setItemDTOList(cfgConfigItemEntities);
        return msConfigItemAddRequest;
    }

    public MsTmpConfigAddRequest convert2TmpConfigItemRequest(ConfigItemDTO configItemDTO) {
        MsTmpConfigAddRequest msTmpConfigAddRequest  = new MsTmpConfigAddRequest();
        List<ItemDTO> itemDTOs =   configItemDTO.getItemList();
        msTmpConfigAddRequest.setInvoiceType(configItemDTO.getInvoiceType());
        List<MsConfigItemTempBean> cfgConfigItemEntities = itemDTOs.stream()
                .filter(Objects::nonNull)
                .map(this::ItemDtoConvert2TmpEntity)
                .collect(Collectors.toList());
        msTmpConfigAddRequest.setEntityList(cfgConfigItemEntities);
        return msTmpConfigAddRequest;
    }
    public ConfigItemDTO convertItemDto(MsConfigItemResponse msConfigItemResponse) {
        List<MsConfigItemBean> entities = msConfigItemResponse.getResult();
        List<ItemDTO> itemDTOs = entities.stream()
                .filter(Objects::nonNull)
                .map(this::entityConvert2ItemDto)
                .collect(Collectors.toList());
        ConfigItemDTO configItemDTO = new ConfigItemDTO();
        configItemDTO.setItemList(itemDTOs);
         return configItemDTO;
    }

    // 规则有效值及枚举值获取
    public ConfigDataDTO convertConfigItemDto(MsConfigItemResponse msConfigItemResponse) {
        List<MsConfigItemBean> entities = msConfigItemResponse.getResult();
        Map<String, ConifgItemDataDTO> map = new HashMap<>();
        for (MsConfigItemBean tmp : entities) {
            ConifgItemDataDTO conifgItemDataDTO = entityConvert2ConifgItemDataDTO(tmp);
            map.put(tmp.getConfigItemName(), conifgItemDataDTO);
        }
//        for (MsBusinessObjMetadataBean tmp : msBusinessObjMetadataBeans) {
//            ConifgItemDataDTO conifgItemDataDTO = map.get(tmp.getFieldName());
//            if (conifgItemDataDTO == null) {
//                continue;
//            }
//            conifgItemDataDTO.setEnumValueList(tmp.getFieldEnumValue());
//            DisplayTypeEnum displayTypeEnum =  DisplayTypeEnum.getDisplayTypeByCode(tmp.getDisplayType());
//            Integer isMulti = displayTypeEnum == DisplayTypeEnum.TEXT ? 0 : 1;
//            conifgItemDataDTO.setIsMulti(isMulti);
//        }
        ConfigDataDTO configDataDTO = new ConfigDataDTO();
        configDataDTO.setConifgItemDataDTOs(Lists.newArrayList(map.values()));
        return configDataDTO;
    }


    // item 转换  ConfigItemEntity
    private MsConfigItemBean ItemDtoConvert2ConfigItemBean(ItemDTO itemDTO) {
        MsConfigItemBean msConfigItemBean = new MsConfigItemBean();
        msConfigItemBean.setConfigItemDisplayName(itemDTO.getItemDisplayName());
        msConfigItemBean.setConfigItemName(itemDTO.getItemName());
        msConfigItemBean.setConfigItemValue(itemDTO.getValue());
        msConfigItemBean.setConfigId(itemDTO.getConfigId());
         return msConfigItemBean;
    }


    // item 转换  ConfigItemEntity
    private MsConfigItemTempBean ItemDtoConvert2TmpEntity(ItemDTO itemDTO) {
        MsConfigItemTempBean msConfigItemTempBean = new MsConfigItemTempBean();
        msConfigItemTempBean.setConfigItemDisplayName(itemDTO.getItemDisplayName());
        msConfigItemTempBean.setConfigItemName(itemDTO.getItemName());
        msConfigItemTempBean.setConfigItemValue(itemDTO.getValue());
        msConfigItemTempBean.setConfigId(itemDTO.getConfigId());
        return msConfigItemTempBean;
    }

    //  ConfigItemEntity 转换 ConifgItemDataDTO
    private ConifgItemDataDTO entityConvert2ConifgItemDataDTO(MsConfigItemBean configItemBean) {
        List<String> itemValue = configItemBean.getConfigItemValue();
        ConifgItemDataDTO itemDTO = new ConifgItemDataDTO();
        itemDTO.setItemDisplayName(configItemBean.getConfigItemDisplayName());
        itemDTO.setItemName(configItemBean.getConfigItemName());
        itemDTO.setValue(itemValue);
         return itemDTO;
    }
    //  ConfigItemEntity 转换 item
    private ItemDTO entityConvert2ItemDto(MsConfigItemBean msConfigItemBean) {
        List<String>  itemValue = msConfigItemBean.getConfigItemValue();
        ItemDTO itemDTO = new ItemDTO();
        itemDTO.setItemDisplayName(msConfigItemBean.getConfigItemDisplayName());
        itemDTO.setItemName(msConfigItemBean.getConfigItemName());
        itemDTO.setValue(itemValue);
        return itemDTO;
    }
    private String convertValueMap(ItemDTO itemDTO) {
        List<String> value = itemDTO.getValue();
        String dictCode = itemDTO.getDictCode();
        String min = itemDTO.getMin();
        String max = itemDTO.getMax();
        Map map = new HashMap<>();
        if (!StringUtils.isEmpty(dictCode)) {
            map.put("dictCode", dictCode);
        }
        if (CollectionUtils.isEmpty(value)) {
            map.put("value", value);
        }
        if (!StringUtils.isEmpty(min)) {
            map.put("min", min);
        }
        if (!StringUtils.isEmpty(max)) {
            map.put("max", max);
        }
        return JsonUtils.writeObjectToFastJson(map);
    }



}
