package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.*;

import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "config", description = "the config API")
public interface ConfigApi {

    @ApiOperation(value = "配置删除", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/config/deleteConfig",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse deleteConfig(@ApiParam(value = "查询配置明细"  ) @RequestBody MsConfigDeleteRequstWithUserInfo msConfigDeleteRequstWithUserInfo);


    @ApiOperation(value = "查询配置明细", notes = "", response = MsConfigItemResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询响应", response = MsConfigItemResponse.class) })
    @RequestMapping(value = "/config/queryConfigDetailRule",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsConfigItemResponse queryConfigDetailRule(@ApiParam(value = "查询配置明细"  ) @RequestBody MsConfigItemQueryRequest msConfigItemQueryRequest);


    @ApiOperation(value = "批量查询查询配置明细", notes = "", response = MsConfigItemResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsConfigItemResponse.class) })
    @RequestMapping(value = "/config/batchQueryConfigDetailRule",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsConfigItemResponse batchQueryConfigDetailRule(@ApiParam(value = "批量查询查询配置明细"  ) @RequestBody MsConfigItemBatchQueryRequest msConfigItemBatchQueryRequest);

    @ApiOperation(value = "用户查询配置", notes = "", response = MsConfigResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询响应", response = MsConfigResponse.class) })
    @RequestMapping(value = "/config/queryConfigRule",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsConfigResponse queryConfigRule(@ApiParam(value = "用户查询配置"  ) @RequestBody MsConfigQueryRequestWithUserInfo msConfigQueryRequestWithUserInfo);


    @ApiOperation(value = "用户查询配置", notes = "", response = MsConfigSummaryResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询响应", response = MsConfigSummaryResponse.class) })
    @RequestMapping(value = "/config/queryConfigSummary",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsConfigSummaryResponse queryConfigSummary(@ApiParam(value = "用户查询配置"  ) @RequestBody MsConfigQueryRequestWithUserInfo msConfigQueryRequestWithUserInfo);


    @ApiOperation(value = "保存配置明细", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/config/saveConfigDetailRule",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse saveConfigDetailRule(@ApiParam(value = "保存配置明细"  ) @RequestBody MsConfigItemAddRequestWithUserInfo msConfigItemAddRequestWithUserInfo);


    @ApiOperation(value = "保存主配置信息", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/config/saveConfigRule",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse saveConfigRule(@ApiParam(value = "新增请求"  ) @RequestBody MsConfigAddRequestWithUserInfo msConfigAddRequestWithUserInfo);

    @ApiOperation(value = "更新票面人", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = Response.class) })
    @RequestMapping(value = "/config/updateConfigOperator",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response updateConfigOperator(@ApiParam(value = "票面人信息"  ) @RequestBody ConfigOperatorRequest configOperatorRequest);

    @ApiOperation(value = "更新票面抬头信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = Response.class) })
    @RequestMapping(value = "/config/updateConfigTtitle",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response updateConfigTtitle(@ApiParam(value = "票面抬头信息"  ) @RequestBody ConfigTtitleRequest configTtitleRequest);

    @ApiOperation(value = "更新公司信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = Response.class) })
    @RequestMapping(value = "/config/updateConfigCompanyName",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response updateConfigCompanyName(@ApiParam(value = "公司信息"  ) @RequestBody ConfigCompanyNameRequest configCompanyNameRequest);
}
