package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.AddCompanyRequest;
import com.xforceplus.seller.config.client.model.ConfigCompanyQueryRequest;
import com.xforceplus.seller.config.client.model.ConfigCompanyQueryResponse;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;

/**
 *非用户中心的公司保存配置表
 */
@Api(value = "configCompany", description = "the configImportReason API")
public interface ConfigCompanyApi {

    @ApiOperation(value = "新增非运营公司", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "configCompany"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "新增响应", response = Response.class) })
    @RequestMapping(value = "/add/company",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response addCompany(@ApiParam(value = "查询自定义条件请求", required = true) @RequestBody AddCompanyRequest request);

    @ApiOperation(
            value = "根据用户id查询公司",
            notes = "",
            response = ConfigCompanyQueryResponse.class,
            authorizations = {@Authorization("x-access-token")},
            tags = {"configCompany"}
    )
    @ApiResponses({@ApiResponse(
            code = 200,
            message = "查询结果",
            response = ConfigCompanyQueryResponse.class
    )})
    @RequestMapping(
            value = {"/query/company"},
            produces = {"application/json"},
            method = {RequestMethod.POST}
    )
    ConfigCompanyQueryResponse queryConfigCompany(@RequestBody ConfigCompanyQueryRequest request);

}
