package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.ConfigApiModel;
import com.xforceplus.seller.config.client.model.MetaBusinessExtResponse;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * Created by yang on 2020/7/17.
 * 获取个性化需求先判断是否开启配置
 * 在大数据量下有一定的优化作用
 */
@Api(value = "customConfig", description = "the configImportReason API")
public interface ConfigCustomApi {
    @ApiOperation(value = "查询折扣率", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "customConfig"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "新增响应", response = Response.class) })
    @RequestMapping(value = "/config/getConfigSlef",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response getSelfConfig(@ApiParam(value = "查询自定义条件请求", required = true) @RequestBody ConfigApiModel request);


    @ApiOperation(value = "查询租户业务单类型扩展属性-枚举类型", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "customConfig"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "新增响应", response = Response.class) })
    @RequestMapping(value = "/config/queryMetaBusinessByAll",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MetaBusinessExtResponse queryMetaBusinessByAll(@ApiParam(value = "查询自定义条件请求", required = true) @RequestBody ConfigApiModel request);


}
