package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.*;

import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "configDevice", description = "the configDevice API")
public interface ConfigDeviceApi {

    @ApiOperation(value = "添加设备", notes = "", response = MsConfigDeviceAddResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigDevice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "添加设备返回", response = MsConfigDeviceAddResponse.class) })
    @RequestMapping(value = "/configDevice/addDevice",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsConfigDeviceAddResponse addDevice(@ApiParam(value = "添加设备请求对象" ,required=true ) @RequestBody MsConfigDeviceAddRequest configDeviceAddRequest);


    @ApiOperation(value = "设置税控设备获取公司列表", notes = "", response = MsConfigDeviceGetCompanyListResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigDevice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "设置税控设备获取公司列表对象返回", response = MsConfigDeviceGetCompanyListResponse.class) })
    @RequestMapping(value = "/configDevice/configDeviceGetCompanyList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsConfigDeviceGetCompanyListResponse configDeviceGetCompanyList(@ApiParam(value = "设置税控设备获取公司列表对象" ,required=true ) @RequestBody MsConfigDeviceGetCompanyListRequest configDeviceGetCompanyListRequest);


    @ApiOperation(value = "查询设备汇总信息", notes = "", response = MsDeviceSummaryQueryResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigDevice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询设备汇总信息返回", response = MsDeviceSummaryQueryResponse.class) })
    @RequestMapping(value = "/configDevice/deviceSummaryQuery",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsDeviceSummaryQueryResponse deviceSummaryQuery(@ApiParam(value = "查询设备汇总信息请求对象" ,required=true ) @RequestBody MsDeviceSummaryQueryRequest deviceSummaryQueryRequest);


    @ApiOperation(value = "查询设备", notes = "", response = MsQueryDeviceResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigDevice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "设备信息获取", response = MsQueryDeviceResponse.class) })
    @RequestMapping(value = "/configDevice/getDeviceList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsQueryDeviceResponse getDeviceList(@ApiParam(value = "查询设备请求对象" ,required=true ) @RequestBody MsConfigDeviceQueryRequest configDeviceQueryRequest);


    @ApiOperation(value = "根据税控设备类型获取全部税控设备", notes = "", response = MsQueryDeviceResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigDevice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "设备信息获取", response = MsQueryDeviceResponse.class) })
    @RequestMapping(value = "/configDevice/queryAllTaxDeviceByTaxDeviceTypes",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsQueryDeviceResponse queryAllTaxDeviceByTaxDeviceTypes(@ApiParam(value = "根据税控设备类型获取全部税控设备请求对象" ,required=true ) @RequestBody MsQueryAllTaxDeviceByTaxDeviceTypesRequest queryAllTaxDeviceByTaxDeviceTypesRequest);


    @ApiOperation(value = "更新设备信息", notes = "", response = MsConfigDeviceUpdateResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigDevice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "更新的设备返回", response = MsConfigDeviceUpdateResponse.class) })
    @RequestMapping(value = "/configDevice/updateDevice",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsConfigDeviceUpdateResponse updateDevice(@ApiParam(value = "更新设备请求对象" ,required=true ) @RequestBody MsConfigDeviceUpdateRequest configDeviceUpdateRequest);


    @ApiOperation(value = "启用设备", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigDevice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsResponse.class) })
    @RequestMapping(value = "/configDevice/updateStatus",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse updateStatus(@ApiParam(value = "更新设备请求对象" ,required=true ) @RequestBody MsConfigUpdateDeviceStatusRequest configUpdateDeviceStatusRequest);

    @ApiOperation(value = "根据拆票id获取备注长度限制", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigDevice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/configDevice/remarkLength/bySplitRuleIds",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<List<QueryRemarkLimitData>> getRemarkLengthBySplitRuleIds(@RequestBody QueryRemarkLimitRequest request);

    @ApiOperation(value = "根据设备信息查询备注限制", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigDevice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/configDevice/remarkLength/query",
            produces = { "application/json" },
            method = RequestMethod.GET)
    Response<List<RemarkLimitData>> getRemarkLengthByDeviceUn(@RequestParam("deviceUn") String deviceUn);

    @ApiOperation(value = "获取实时库存", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigDevice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/configDevice/queryInventory",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<List<QueryInventoryResult>> queryInventory(@RequestBody QueryInventoryRequest request);

}
