package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.*;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "configLicense", description = "the configLicense API")
public interface ConfigLicenseApi {

    @ApiOperation(value = "生成授权文件", notes = "", response = MsAcquireLicenseResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigLicense", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "授权文件获取响应", response = MsAcquireLicenseResponse.class) })
    @RequestMapping(value = "/configLicense/acquireLicense",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAcquireLicenseResponse acquireLicense(@ApiParam(value = "生成授权文件请求对象" ,required=true ) @RequestBody MsConfigAcquireLicenseRequest configAcquireLicenseRequest);


    @ApiOperation(value = "发送授权文件", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigLicense", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsResponse.class) })
    @RequestMapping(value = "/configLicense/sendLicense",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse sendLicense(@ApiParam(value = "发送授权文件请求对象" ,required=true ) @RequestBody MsConfigSendLicenseRequest configSendLicenseRequest);

    @ApiOperation(value = "获取激活码", notes = "", response = MsResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigLicense", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsResponse.class) })
    @RequestMapping(value = "/configLicense/getAcvtiveCode",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsGetActiveResponse getActiveCode(@ApiParam(value = "发送授权文件请求对象" ,required=true ) @RequestBody GetActiveCodeRequest configSendLicenseRequest);

}
