package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.MsConfigQueryInvoiceTypeRequest;
import com.xforceplus.seller.config.client.model.MsQueryInvoiceTypeResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "configSystem", description = "the configSystem API")
public interface ConfigSystemApi {

    @ApiOperation(value = "查询发票类型", notes = "", response = MsQueryInvoiceTypeResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigSystem", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询发票类型响应", response = MsQueryInvoiceTypeResponse.class) })
    @RequestMapping(value = "/configSystem/queryInvoiceType",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsQueryInvoiceTypeResponse queryInvoiceType(@ApiParam(value = "查询发票类型" ,required=true ) @RequestBody MsConfigQueryInvoiceTypeRequest configQueryInvoiceTypeRequest);

}
