package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.*;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "configTerminal", description = "the configTerminal API")
public interface ConfigTerminalApi {

    @ApiOperation(value = "新增终端", notes = "", response = MsAddTerminalResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigTemial", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "终端新增", response = MsAddTerminalResponse.class) })
    @RequestMapping(value = "/configTerminal/addTerminal",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAddTerminalResponse addTerminal(@ApiParam(value = "终端新增"  ) @RequestBody MsConfigAddTerminalRequest configAddTerminalRequest);


    @ApiOperation(value = "导入终端", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigTemial", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsResponse.class) })
    @RequestMapping(value = "/configTerminal/import",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse callImport(@ApiParam(value = "更新终端请求对象" ,required=true ) @RequestBody Object configImportTerminalRequest);


    @ApiOperation(value = "导出终端", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigTemial", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsResponse.class) })
    @RequestMapping(value = "/configTerminal/export",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse export(@ApiParam(value = "更新终端请求对象" ,required=true ) @RequestBody Object configExportTerminalRequest);


    @ApiOperation(value = "根据用户权限查询终端", notes = "", response = MsQueryTerminalResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigTemial", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "终端信息获取响应", response = MsQueryTerminalResponse.class) })
    @RequestMapping(value = "/configTerminal/getAuthTerminalList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsQueryTerminalResponse getAuthTerminalList(@ApiParam(value = "查询终端请求对象" ,required=true ) @RequestBody MsConfigTemialAuthQueryRequest configTemialAuthQueryRequest);


    @ApiOperation(value = "查询开票终端", notes = "", response = MsQueryMakeOutTerminalResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigTemial", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "终端信息获取响应", response = MsQueryMakeOutTerminalResponse.class) })
    @RequestMapping(value = "/configTerminal/getMakeOutTerminalList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsQueryMakeOutTerminalResponse getMakeOutTerminalList(@ApiParam(value = "查询开票终端请求对象" ,required=true ) @RequestBody MsConfigTemialQueryMakeOutRequest configTemialQueryMakeOutRequest);


    @ApiOperation(value = "查询终端", notes = "", response = MsQueryTerminalResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigTemial", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "终端信息获取响应", response = MsQueryTerminalResponse.class) })
    @RequestMapping(value = "/configTerminal/getTerminalList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsQueryTerminalResponse getTerminalList(@ApiParam(value = "查询终端请求对象" ,required=true ) @RequestBody MsConfigTemialQueryRequest configTemialQueryRequest);


    @ApiOperation(value = "更新终端信息", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigTemial", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsResponse.class) })
    @RequestMapping(value = "/configTerminal/update",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse update(@ApiParam(value = "更新终端请求对象" ,required=true ) @RequestBody MsConfigUpdateTerminalRequest configUpdateTerminalRequest);


    @ApiOperation(value = "更新终端状态", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigTemial", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsResponse.class) })
    @RequestMapping(value = "/configTerminal/updateStatus",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse updateStatus(@ApiParam(value = "更新终端状态请求对象" ,required=true ) @RequestBody MsConfigUpdateTerminalStatusRequest configUpdateTerminalStatusRequest);

    @ApiOperation(value = "新获取终端信息", notes = "", response = MsQueryTerminalResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigTemial", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = MsQueryTerminalResponse.class) })
    @RequestMapping(value = "/configTerminal/new/getTerminalList",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsQueryTerminalResponse getTerminalList(@RequestBody MsQueryTerminalRequest request);
}
