package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.*;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;


@Api(value = "configTitle", description = "the config API")
public interface ConfigTitleApi {

    @ApiOperation(value = "用户查询抬头信息", notes = "", response = MsQueryInvoiceTitleResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigTitle", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "统一返回", response = MsQueryInvoiceTitleResponse.class) })
    @RequestMapping(value = "/configTitle/queryInvoiceTitle",
        produces = { "application/json" },
        method = RequestMethod.POST)
    MsQueryInvoiceTitleResponse queryInvoiceTitle(@ApiParam(value = "用户查询抬头信息", required = true) @RequestBody MsQueryInvoiceTitleRequest msQueryInvoiceTitleRequest);
}
