package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.*;

import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import java.util.List;
import java.util.Map;


@Api(value = "invoiceSplitConfig", description = "the invoiceSplitConfig API")
public interface InvoiceSplitConfigApi {

    @ApiOperation(value = "查询匹配最优配置规则", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/invoiceSplitConfig/getOptimalMatchConfig",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse getOptimalMatchConfig(@ApiParam(value = "查询匹配最优配置规则"  ) @RequestBody MsConfigQueryRequest msConfigQueryRequest);


    @ApiOperation(value = "(零售)查询匹配最优配置规则", notes = "", response = MsResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/order/getOptimalMatchConfig",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsResponse getOrderOptimalMatchConfig(@ApiParam(value = "查询匹配最优配置规则"  ) @RequestBody MsConfigQueryRequest msConfigQueryRequest);

    @ApiOperation(value = "查询匹配的所有规则", notes = "", response = MsResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/invoiceSplitConfig/queryAllSysConfig",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsResponse queryAllSysConfig(@ApiParam(value = "查询匹配的所有规则"  ) @RequestBody MsConfigQueryRequest msConfigQueryRequest);

    @ApiOperation(value = "批量查询匹配的各自最优规则", notes = "", response = MsResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/invoiceSplitConfig/batchQueryOptimalMatchConfig",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsResponse<Map<String, List<String>>> batchQueryOptimalMatchConfig(@ApiParam(value = "查询匹配全部配置规则") @RequestBody MsConfigBatchQueryRequest request);

    @ApiOperation(value = "查询匹配的各自最优规则集合", notes = "", response = MsResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/invoiceSplitConfig/getOptimalMatchConfigList",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsResponse<String> getOptimalMatchConfigList(@ApiParam(value = "查询匹配最优配置规则") @RequestBody MsConfigQueryRequest msConfigQueryRequest);

}
