package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "pageProcessConfig", description = "the pageProcessConfig API")
public interface PageProcessConfigApi {

    @ApiOperation(value = "查询页面流程配置", notes = "", response = MsConfigResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询响应", response = MsConfigResponse.class) })
    @RequestMapping(value = "/pageProcessConfig/queryEffectivePageProcessRule",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsConfigResponse queryEffectivePageProcessRule(@ApiParam(value = "用户查询配置"  ) @RequestBody MsConfigQueryRequest msConfigQueryRequest);

}
