package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.MsTmpConfigAddRequest;
import com.xforceplus.seller.config.client.model.MsTmpConfigResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "tempConfig", description = "the tempConfig API")
public interface TempConfigApi {

    @ApiOperation(value = "保存临时规则", notes = "", response = MsTmpConfigResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询响应", response = MsTmpConfigResponse.class) })
    @RequestMapping(value = "/tempConfig/saveTmpConfigRule",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsTmpConfigResponse saveTmpConfigRule(@ApiParam(value = "临时规则保存"  ) @RequestBody MsTmpConfigAddRequest tmpConfigAddRequest);

}
