package com.xforceplus.seller.config.client.configparser;/**
 * Created by admin on 2018/10/17.
 */

import com.xforceplus.xplatframework.utils.JsonUtils;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @Author zzw
 * @Description 枚举在 config存储的格式 [{code:1,text:2,value:dfdf}]
 * @Date
 * @return
 **/
public class EnumBean {
    @ApiModelProperty("表示此枚举值的code")
    private String code;
    @ApiModelProperty("表示此枚举值的文本描述")
    private String text;
    @ApiModelProperty("表示此枚举值的值")
    private String value;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    //字符串
    public static EnumBean transString2Enum(String enumValueStr) {
       return JsonUtils.writeJsonToObject(enumValueStr, EnumBean.class);
    }

    public static List<EnumBean> transString2EnumList(String enumValueStr) {
        return JsonUtils.writeJsonToListObject(enumValueStr, EnumBean.class);
    }
}
