package com.xforceplus.seller.config.client.constant;

import java.util.Arrays;
import java.util.List;

/**
 * Created by zzw on 2018/9/19.
 * 规则类型枚举
 */
public enum BusinessSalesBillTypeEnum {
    /**
     * 销方
     */
    AR("AR","销方"),
    /**
     *  购方
     */
    AP("AP","购方");

    private String businessSalesBillType;

    private String businessSalesBillTypeDesc;

    BusinessSalesBillTypeEnum(String businessSalesBillType, String businessSalesBillTypeDesc) {
        this.businessSalesBillType = businessSalesBillType;
        this.businessSalesBillTypeDesc = businessSalesBillTypeDesc;
    }

    public String getBusinessSalesBillType() {
        return businessSalesBillType;
    }

    public void setBusinessSalesBillType(String businessSalesBillType) {
        this.businessSalesBillType = businessSalesBillType;
    }

    public String getBusinessSalesBillTypeDesc() {
        return businessSalesBillTypeDesc;
    }

    public void setBusinessSalesBillTypeDesc(String businessSalesBillTypeDesc) {
        this.businessSalesBillTypeDesc = businessSalesBillTypeDesc;
    }

    public static boolean checkIsExist(String businessSalesBillType){
        List<BusinessSalesBillTypeEnum> list = Arrays.asList(BusinessSalesBillTypeEnum.values());
        for (BusinessSalesBillTypeEnum businessSalesBillTypeEnum:list) {
            if (businessSalesBillTypeEnum.getBusinessSalesBillType().equals(businessSalesBillType)){
                return true;
            }
        }
        return false;
    }

}
