package com.xforceplus.seller.config.client.constant;


import java.util.stream.Stream;

/**
 * 项目名称:  phoenix-config
 * 模块名称:
 * 说明: 规则类型枚举
 * JDK 版本: JDK1.8
 * @author 作者： Created by zzw
 * 创建日期：2018/9/19.
 */
public enum ConfigTypeEnum {
    /**
     * 拆票规则
     */
    SPLIT_CONFIG_TYPE(1,"拆票规则","invoiceSplitConfig"),
    /**
     * 拆合规则
     */
    MERGE_CONFIG_TYPE(2,"拆合规则","billMergeSplitConfig"),
    /**
     * 票面信息规则
     */
    INVOICE_CONFIG_TYPE(3,"票面信息规则","invoiceInfoConfig"),
    /**
     * 票面人员规则
     */
    INVOICE_USER_CONFIG_TYPE(4,"票面人员规则","invoiceMemberInfoConfig"),
    /**
     * 业务流程规则
     */
    PROCESS_CONFIG_TYPE(5,"业务流程规则","pageProcssConfig"),
    /**
     * 系统规则
     */
    SYS_CONFIG_TYPE(6,"系统规则","sysConfig"),

    /**
     * 组合合并规则
     */
    BILL_MERGE_TYPE(7,"组合合并规则","mergeRule"),

    /**
     * 发票匹配业务单规则
     */
    BILL_INVOICE_MATCH_TYPE(8, "发票匹配业务单", "invoiceMatchConfig"),

    /**
     * 虚拟发票自动开具自动红冲规则
     */
    VIRTUAL_INVOICE_AUTO_TYPE(9, "虚拟发票自动开具自动红冲规则", "virtualInvoiceAutoRule"),

    /**
     * 发票邮件推送规则
     */
    INVOICE_MAIL_RULE_CONFIG_TYPE(10, "发票邮件推送规则", "invoiceMailRuleConfig"),

    /**
     * 发票邮件推送规则
     */
    INVOICE_OPERRATIOON_CONFIG_TYPE(11, "发票红冲作废原因规则", "invoiceOperationConfig"),

    /**
     * 未知拆票规则
     */
    UNKNOWN(0, "未知规则", "unknown"),

    /**
     * 票面信息规则
     */
    MULTI_INVOICE_TITLE_CONFIG_TYPE(12,"抬头信息规则","invoiceTitleConfig"),
    ;
    private Integer configType;
    private String configTypeDesc;
    private String objCode;

    ConfigTypeEnum(Integer configType, String configTypeDesc,String objCode) {
        this.configType = configType;
        this.configTypeDesc = configTypeDesc;
        this.objCode = objCode;
    }

    public static ConfigTypeEnum of(Integer configType){
        if(configType == null){
            return ConfigTypeEnum.UNKNOWN;
        }

        return Stream.of(ConfigTypeEnum.values()).filter( c->c.configType == configType) .findFirst().orElse(ConfigTypeEnum.UNKNOWN);
    }

    public Integer getConfigType() {
        return configType;
    }

    public void setConfigType(Integer configType) {
        this.configType = configType;
    }

    public String getConfigTypeDesc() {
        return configTypeDesc;
    }

    public void setConfigTypeDesc(String configTypeDesc) {
        this.configTypeDesc = configTypeDesc;
    }

    public String getObjCode() {
        return objCode;
    }

    public void setObjCode(String objCode) {
        this.objCode = objCode;
    }

    public static ConfigTypeEnum getConfigTypeByValue(Integer configType) {
        ConfigTypeEnum[] configTypeEnums = ConfigTypeEnum.values();
        for (ConfigTypeEnum tmp : configTypeEnums) {
            if (tmp.getConfigType().equals(configType)) {
                return tmp;
            }
        }
        return null;
    }

}
