package com.xforceplus.seller.config.client.constant;

import org.apache.commons.lang3.StringUtils;

/**
 * Created by admin on 2018/10/29.
 */
public enum DisplayTypeEnum {
    /**
     * 文本框
     */
    TEXT("1","文本框"),
    /**
     * 下拉菜单
     */
    PULL_DOWN("2","下拉菜单"),
    /**
     * 复选框
     */
    CHECK_BOX("3","复选框"),
    /**
     * 单选框
     */
    RADIO("4","单选框"),
    ;
    private String displayType;
    private String displayTypeDesc;

    DisplayTypeEnum(String displayType, String displayTypeDesc) {
        this.displayType = displayType;
        this.displayTypeDesc = displayTypeDesc;
    }

    public String getDisplayType() {
        return displayType;
    }

    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    public String getDisplayTypeDesc() {
        return displayTypeDesc;
    }

    public void setDisplayTypeDesc(String displayTypeDesc) {
        this.displayTypeDesc = displayTypeDesc;
    }

    public static DisplayTypeEnum getDisplayTypeByCode(String displayType) {
        DisplayTypeEnum[] displayTypeEnums = DisplayTypeEnum.values();
        for (DisplayTypeEnum tmp : displayTypeEnums) {
            if (StringUtils.equals(displayType,tmp.getDisplayType())) {
                return tmp;
            }
        }
        return null;
    }
}
