package com.xforceplus.seller.config.client.constant;


/**
 * 合并规则枚举
 */
public enum MergeRuleEnum {
    /**
     * 拆票规则
     */
    quantity_add(1,"数量相加"),
    quantity_merge_To_One(2,"数量合并为1"),
    save_price(3,"保留单价"),
    no_quantity_no_Price(4,"无数量无单价"),
    quantity_to_whole(5,"数量取整"),

    // 中台徐福记专用 ( 勿动)
    BY_PRICE(-1,"保单价：单价不变，重算数量"),
    BY_QUANTITY(-2,"保数量：数量不变，重算单价"),
    BY_PRICE_I(-3,"保单价且数量取整：单价不变，重算数量，再取整后重算单价"),
    BY_QUANTITY_I(-4,"保数量且数量取整：数量取整后重算单价");

    private Integer value;
    private String valueDesc;


    MergeRuleEnum(Integer value, String valueDesc) {
        this.value = value;
        this.valueDesc = valueDesc;
    }



    public Integer getvalue() {
        return value;
    }

    public void setvalue(Integer value) {
        this.value = value;
    }

    public String getvalueDesc() {
        return valueDesc;
    }

    public void setvalueDesc(String valueDesc) {
        this.valueDesc = valueDesc;
    }



    public static MergeRuleEnum getvalueByValue(Integer value) {
        MergeRuleEnum[] valueEnums = MergeRuleEnum.values();
        for (MergeRuleEnum tmp : valueEnums) {
            if (tmp.getvalue().equals(value)) {
                return tmp;
            }
        }
        return null;
    }
}
