package com.xforceplus.seller.config.client.matchparser.impl;
import com.xforceplus.seller.config.client.constant.BusinessSalesBillTypeEnum;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.matchparser.ConfigMatchParser;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigBizBillAttribute;
import com.xforceplus.seller.config.client.parse.BaseRuleBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.util.ReflectUtil;
import com.xforceplus.xplatframework.utils.JsonUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 项目名称: 票易通
 * 模块名称: 单据拆、合规则匹配管理
 * JDK 版本: JDK1.8
 * 说明:
 * 作者(@author): Created by zzw on 2018/10/24.
 * 创建时间: 2018/10/24.
 */
@Component
public class ConfigMatchParserImpl implements ConfigMatchParser {
    private Logger logger = LoggerFactory.getLogger(ConfigMatchParserImpl.class);
    /**
     *
     * @param cfgConfigEntities 购销对下的规则列表
     * @param cfgConfigEntity 单据头组装的规则实体
     * @param configParser 规则解析器
     * @return
     */
    @Override
    public BaseRuleBean configMatch(List<MsConfigBean> cfgConfigEntities, MsConfigBean cfgConfigEntity, ConfigParser configParser) {
        if (cfgConfigEntity.getConfigType().equals(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType())
                || cfgConfigEntity.getConfigType().equals(ConfigTypeEnum.INVOICE_USER_CONFIG_TYPE.getConfigType())
                || cfgConfigEntity.getConfigType().equals(ConfigTypeEnum.INVOICE_CONFIG_TYPE.getConfigType())
                || cfgConfigEntity.getConfigType().equals(ConfigTypeEnum.SYS_CONFIG_TYPE.getConfigType()) ) {
            return splitConfigRuleMatch(cfgConfigEntities, cfgConfigEntity, configParser);
        }
        int maxScore = 0;
        if (CollectionUtils.isEmpty(cfgConfigEntities)) {
            return null;
        }
        MsConfigBean result = cfgConfigEntities.get(0);
        logger.info("configMatch---cfgConfigEntity:{}", cfgConfigEntity);
        for (MsConfigBean tmp : cfgConfigEntities) {
            int score = matchSellerInfo(cfgConfigEntity, tmp);
            logger.info("configMatch--- matchSellerInfo tmp:{}--score:{}", JsonUtils.writeObjectToFastJson(tmp), score);
            if (score == -1) {
                continue;
            }

            int matchPurchaserScore = matchPurchaserInfo(cfgConfigEntity, tmp);
            logger.info("configMatch--- matchPurchaserInfo tmp:{}--score:{}", JsonUtils.writeObjectToFastJson(tmp), matchPurchaserScore);
            if ( matchPurchaserScore == -1) {
                continue;
            }
            score += matchPurchaserScore;
            int matchExtScore = matchExtData(cfgConfigEntity, tmp);
            logger.info("configMatch--- matchExtData tmp:{}--score:{}", JsonUtils.writeObjectToFastJson(tmp), matchExtScore);
             if (matchExtScore == -1) {
                continue;
            }
            score += matchExtScore;
            if (score > maxScore) {
                maxScore = score;
                result = tmp;
                logger.info("matched configId====={}", tmp.getConfigId());
            }
        }
        if (result == null) {
            return null;
        }
        logger.info("configMatch--- match result:{}", result);
        return configParser.parse(result.getItemList());
    }


    /**
     * targetMsConfigBeanList 中元素满足：select * from cfg_config where config_type = xx and seller_group_id = xx and invoice_type = 'xx' and `status` = 1 筛选条件
     * 1. compay-compay-ce  业务单类型 有的话就相等，否者就是空的
     * 2. compay-all-ce  业务单类型 有的话就相等，否者就是空的
     * 3. group-compay-ce 业务单类型 有的话就相等，否者就是空的
     * 4. group-all-ce 业务单类型 有的话就相等，否者就是空的
     * 5. 默认规则 业务单类型 有的话就相等，否者就是空的
     * @param targetMsConfigBeanList   待匹配的拆分规则对象列表
     * @param msConfigBeanFromBill     当前用户单据转换出的规则
     * @param configParser 解析器对象
     * @return 返回最佳拆分规则
     */
    @Override
    public BaseRuleBean splitConfigRuleMatch(List<MsConfigBean> targetMsConfigBeanList,MsConfigBean msConfigBeanFromBill,ConfigParser configParser) {
        MsConfigBean retMsConfigBean = getBestMatchConfig(targetMsConfigBeanList, msConfigBeanFromBill);
        if (null == retMsConfigBean) {
            return null;
        }
        return configParser.parse(retMsConfigBean.getItemList());
    }

    /**
     * 计算目标规则 对于 单据数据的 匹配得分
     * @param sourceData 单据数据转义规则对象
     * @param targetData 目标规则对象
     * @return
     */
    private int matchSellerInfo(MsConfigBean sourceData,MsConfigBean targetData) {
        //销方规则匹配
        int score = 0;
        logger.info("sourceData.getSellerGroupId():{}, targetData.getSellerGroupId():{}", sourceData.getSellerGroupId(), targetData.getSellerGroupId());
        if (!sourceData.getSellerGroupId().equals(targetData.getSellerGroupId())) {
            return -1;
        } else if(sourceData.getSellerGroupId().equals(targetData.getSellerGroupId()))  {
            score= +2;
        }

        logger.info("sourceData.getPurchaserGroupId():{}, targetData.getPurchaserGroupId():{}", sourceData.getPurchaserGroupId(), targetData.getPurchaserGroupId());
        if (!sourceData.getPurchaserGroupId().equals(targetData.getPurchaserGroupId()) && sourceData.getPurchaserGroupId() != 0) {
            return -1;
        } else if(sourceData.getPurchaserGroupId().equals(targetData.getPurchaserGroupId())) {
            score= +2;
        }

        logger.info("sourceData.getSellerTaxNo():{}, targetData.getSellerTaxNo():{}", sourceData.getSellerTaxNo(), targetData.getSellerTaxNo());
        if (!StringUtils.isEmpty(sourceData.getSellerTaxNo()) && !targetData.getSellerTaxNo().equals(sourceData.getSellerTaxNo())) {
            return -1;
        } else if(!StringUtils.isEmpty(sourceData.getSellerTaxNo()) &&  targetData.getSellerTaxNo().equals(sourceData.getSellerTaxNo()))  {
            score= +160;
        }
        logger.info("sourceData.getSalesbillType():{}, targetData.getSalesbillType():{}", sourceData.getSalesbillType(), targetData.getSalesbillType());

        logger.info("sourceData.getPurchaserTaxNo():{}, targetData.getPurchaserTaxNo():{}", sourceData.getPurchaserTaxNo(), targetData.getPurchaserTaxNo());
        if (!StringUtils.isEmpty(sourceData.getPurchaserTaxNo()) && !targetData.getPurchaserTaxNo().equals(sourceData.getPurchaserTaxNo())) {
            return -1;
        } else if(!StringUtils.isEmpty(sourceData.getPurchaserTaxNo()) &&  targetData.getPurchaserTaxNo().equals(sourceData.getPurchaserTaxNo()))  {
            score= +160;
        }

        // 目标规则业务类型不为空时，如果两者的规则不一致表示不匹配
        if (!StringUtils.isEmpty(sourceData.getSalesbillType()) && !targetData.getSalesbillType().equals(sourceData.getSalesbillType())) {
            return -1;
        }else if(!StringUtils.isEmpty(sourceData.getSalesbillType()) &&  targetData.getSalesbillType().equals(sourceData.getSalesbillType())) {
            score += 4;
        }
        return score;
    }
    /**
     * 计算目标规则 对于 单据数据的 匹配得分
     * @param sourceData 单据数据转义规则对象
     * @param targetData 目标规则对象
     * @return
     */
    private int matchPurchaserInfo(MsConfigBean sourceData,MsConfigBean targetData) {
        Integer score = 0;
        Long sourcePurchaserGroupId = sourceData.getPurchaserGroupId();
        Long targePurchaserGroupId = targetData.getPurchaserGroupId();
        String sourcePurchaserNo = sourceData.getPurchaserNo();
        String targePurchaserNo = targetData.getPurchaserNo();

        Long sourceSellerGroupId = sourceData.getSellerGroupId();
        Long targeSellerGroupId = targetData.getSellerGroupId();
        String sourceSellerNo = sourceData.getSellerNo();
        String targeSellerNo = targetData.getSellerNo();

        String sourceBillType = sourceData.getSalesbillType();
        String targeBillType = targetData.getSalesbillType();

      /*  String sourceOrgNo = sourceData.getExt1();
        String targetOrgNo = targetData.getExt1();*/
        logger.info("targePurchaserGroupId==={}, sourcePurchaserGroupId==={}", targePurchaserGroupId, sourcePurchaserGroupId);
        if (sourcePurchaserGroupId != null ){
            if(!targePurchaserGroupId.equals(sourcePurchaserGroupId) ) {
                return -1;
            }else {
                score= +2;
            }
        }
        logger.info("targeSellerGroupId==={}, sourceSellerGroupId==={}", targeSellerGroupId, sourceSellerGroupId);
        if (sourceSellerGroupId != null ){
            if(!targeSellerGroupId.equals(sourceSellerGroupId) ) {
                return -1;
            }else {
                score= +2;
            }
        }

        logger.info("sourcePurchaserNo==={}, targePurchaserNo==={}", sourcePurchaserNo, targePurchaserNo);
        if (!StringUtils.isEmpty(sourcePurchaserNo)){
            if(!StringUtils.equals(sourcePurchaserNo,targePurchaserNo)) {
                return -1;
            }else {
                score= +2;
            }
        }

        logger.info("sourceSellerNo==={}, targeSellerNo==={}", sourceSellerNo, targeSellerNo);
        if (!StringUtils.isEmpty(sourceSellerNo)){
            if(!StringUtils.equals(sourceSellerNo,targeSellerNo)) {
                return -1;
            }else {
                score= +2;
            }
        }
        logger.info("sourceBillType==={}, targeBillType==={}", sourceBillType, targeBillType);
        if (!StringUtils.isEmpty(sourceBillType)){
            if(!StringUtils.equals(sourceBillType,targeBillType  )) {
                return -1;
            }else {
                score= +4;
            }
        }
       /* logger.info("sourceOrgNo==={}, targetOrgNo==={}", sourceOrgNo, targetOrgNo);
        if(!StringUtils.isEmpty(sourceOrgNo)  ){
            if(!StringUtils.equals(sourceOrgNo,targetOrgNo  )) {
                return -1;
            }else {
                score= +170;
            }
        }*/
        return score;
    }
    private int matchExtData(MsConfigBean sourceData,MsConfigBean targetData) {
        int score = 0;
        if(!StringUtils.isEmpty(targetData.getExt2())  ){
            if(!targetData.getExt2().equals(sourceData.getExt2())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt3())  ){
            if(!targetData.getExt3().equals(sourceData.getExt3())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt4())  ){
            if(!targetData.getExt4().equals(sourceData.getExt4())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt5())  ){
            if(!targetData.getExt5().equals(sourceData.getExt5())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt6())  ){
            if(!targetData.getExt6().equals(sourceData.getExt6())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt7())  ){
            if(!targetData.getExt7().equals(sourceData.getExt7())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt8())  ){
            if(!targetData.getExt8().equals(sourceData.getExt8())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt9())  ){
            if(!targetData.getExt9().equals(sourceData.getExt9())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt10())  ){
            if(!targetData.getExt10().equals(sourceData.getExt10())) {
                return -1;
            }
            score=+6;
        }

        if(!StringUtils.isEmpty(targetData.getExt11())  ){
            if(!targetData.getExt11().equals(sourceData.getExt11())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt12())  ){
            if(!targetData.getExt12().equals(sourceData.getExt12())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt13())  ){
            if(!targetData.getExt13().equals(sourceData.getExt13())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt14())  ){
            if(!targetData.getExt14().equals(sourceData.getExt14())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt15())  ){
            if(!targetData.getExt15().equals(sourceData.getExt15())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt16())  ){
            if(!targetData.getExt16().equals(sourceData.getExt16())) {
                return -1;
            }
            score=+6;
        }


        if(!StringUtils.isEmpty(targetData.getExt17())  ){
            if(!targetData.getExt17().equals(sourceData.getExt17())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt18())  ){
            if(!targetData.getExt18().equals(sourceData.getExt18())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt19())  ){
            if(!targetData.getExt19().equals(sourceData.getExt19())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt20())  ){
            if(!targetData.getExt20().equals(sourceData.getExt20())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt21())  ){
            if(!targetData.getExt21().equals(sourceData.getExt21())) {
                return -1;
            }
            score=+6;
        }if(!StringUtils.isEmpty(targetData.getExt22())  ){
            if(!targetData.getExt22().equals(sourceData.getExt22())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt23())  ){
            if(!targetData.getExt23().equals(sourceData.getExt23())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt24())  ){
            if(!targetData.getExt24().equals(sourceData.getExt24())) {
                return -1;
            }
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt25())  ){
            if(!targetData.getExt25().equals(sourceData.getExt25())) {
                return -1;
            }
            score=+6;
        }
        return score;
    }

    private int getScoreByExtFields(MsConfigBean sourceData,MsConfigBean targetData) {
        int score = 0;
        if(!StringUtils.isEmpty(targetData.getExt2()) && targetData.getExt2().equals(sourceData.getExt2())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt3()) && targetData.getExt3().equals(sourceData.getExt3())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt4()) && targetData.getExt4().equals(sourceData.getExt4())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt5()) && targetData.getExt5().equals(sourceData.getExt5())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt6()) && targetData.getExt6().equals(sourceData.getExt6())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt7()) && targetData.getExt7().equals(sourceData.getExt7())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt8()) && targetData.getExt8().equals(sourceData.getExt8())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt9()) && targetData.getExt9().equals(sourceData.getExt9())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt10()) && targetData.getExt10().equals(sourceData.getExt10())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt11()) && targetData.getExt11().equals(sourceData.getExt11())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt12()) && targetData.getExt12().equals(sourceData.getExt12())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt13()) && targetData.getExt13().equals(sourceData.getExt13())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt14()) && targetData.getExt14().equals(sourceData.getExt14())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt15()) && targetData.getExt15().equals(sourceData.getExt15())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt16()) && targetData.getExt16().equals(sourceData.getExt16())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt17()) && targetData.getExt17().equals(sourceData.getExt17())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt18()) && targetData.getExt18().equals(sourceData.getExt18())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt19()) && targetData.getExt19().equals(sourceData.getExt19())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt20()) && targetData.getExt20().equals(sourceData.getExt20())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt21()) && targetData.getExt21().equals(sourceData.getExt21())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt22()) && targetData.getExt22().equals(sourceData.getExt22())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt23()) && targetData.getExt23().equals(sourceData.getExt23())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt24()) && targetData.getExt24().equals(sourceData.getExt24())){
            score=+6;
        }
        if(!StringUtils.isEmpty(targetData.getExt25()) && targetData.getExt25().equals(sourceData.getExt25())){
            score=+6;
        }
        return score;
    }

    @Override
    public MsConfigBean getBestMatchConfig(List<MsConfigBean> targetMsConfigBeanList,MsConfigBean msConfigBeanFromBill) {
        if (CollectionUtils.isEmpty(targetMsConfigBeanList)) {
            return null;
        }

        //当前等分最高的规则配置
        int maxScore = 0;
        MsConfigBean retMsConfigBean = null;
        Map<String,String> bean = null;
        try {
            bean = ReflectUtil.bean2map(msConfigBeanFromBill);
        } catch (Exception e) {
            logger.error("@getBestMatchConfig ", e);
        }
        for (MsConfigBean matchingMsConfigBean : targetMsConfigBeanList) {
            int score = 0 ;
            // #2020-5-14 匹配规则
            // 匹配规则定义
            // bill ~ cfg
            // A,B    A,B 匹配
            // A      A,B 不匹配
            // A,B    A   匹配
            // A,B    A,C 不匹配
            boolean match = true;
            List<MsConfigBizBillAttribute> attributes = matchingMsConfigBean.getAttributes();
            if(!CollectionUtils.isEmpty(attributes)){
                int matchCount = 0;
                for(MsConfigBizBillAttribute attr : attributes){
                    String value = bean.get(attr.getFieldName());
                    // 有属性不匹配则跳出 cfg[A,B]和cfg[A,C]场景
                    if(value == null || !value.equals(attr.getValue())){
                        match = false;
                        //降权
                        score = score - 6;
                        break;
                    }
                    matchCount++;
                }
                // 规则不匹配,跳出
                if(!match){
                    continue;
                }else {
                    // 属性命中 +6 分
                    score = score + 6 * matchCount;
                }
            }

            //规则创建方
            String bBillType = matchingMsConfigBean.getBusinessBillType();

            //AR创建
            if (bBillType.equals(BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType())) {

                //销方集团Id匹配得分
                if (null !=matchingMsConfigBean.getSellerGroupId() && matchingMsConfigBean.getSellerGroupId() > 0 && matchingMsConfigBean.getSellerGroupId().equals(msConfigBeanFromBill.getSellerGroupId())) {
                    score += 2;
                }else {
                    //销方集团Id 不相等，放弃本次的匹配规则， 按筛选条件，不可能运行到该分支
                    logger.info("AR---销方集团Id 不相等，放弃本次的匹配规则， 按筛选条件，不可能运行到该分支 configId:{}",matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId());
                    continue;
                }

                //销方公司匹配得分
                if (!StringUtils.isEmpty(matchingMsConfigBean.getSellerTaxNo()) && matchingMsConfigBean.getSellerTaxNo().equals(msConfigBeanFromBill.getSellerTaxNo())) {
                    score += 160;
                }else if (!StringUtils.isEmpty(matchingMsConfigBean.getSellerTaxNo())){
                    //销方集团Id相等、公司有值且不相等：该规则不使用
                    logger.info("AR---销方集团Id相等、公司有值且不相等：该规则不使用 configId:{}",matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId());
                    continue;
                }
                //销方公司匹配得分
                if (matchingMsConfigBean.getSysOrgId()!=null&&matchingMsConfigBean.getSysOrgId()!=0L&& matchingMsConfigBean.getSysOrgId().equals(msConfigBeanFromBill.getSysOrgId())) {
                    score += 160;
                }else if (matchingMsConfigBean.getSysOrgId()!=null&&matchingMsConfigBean.getSysOrgId()!=0L){
                    //销方集团Id相等、公司有值且不相等：该规则不使用
                    logger.info("AR---销方集团Id相等、组织有值且不相等：该规则不使用 configId:{}",matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId());
                    continue;
                }

                //销方子组织匹配得分
                /*if (!StringUtils.isEmpty(matchingMsConfigBean.getExt1()) && matchingMsConfigBean.getExt1().equals(msConfigBeanFromBill.getExt1()) ) {
                    score += 170;
                } else if(!StringUtils.isEmpty(matchingMsConfigBean.getExt1())) {
                    //销方集团Id相等、公司有值且相等、子组织有值且不相等：该规则不使用
                    logger.info("AR---销方集团Id相等、公司有值且相等、子组织有值且不相等：该规则不使用 configId:{}",matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId());
                    continue;
                }*/

                //购方集团匹配得分
                if (null != matchingMsConfigBean.getPurchaserGroupId() && matchingMsConfigBean.getPurchaserGroupId()>0 && matchingMsConfigBean.getPurchaserGroupId().equals(msConfigBeanFromBill.getPurchaserGroupId())) {
                    score += 2;
                }else if(null != matchingMsConfigBean.getPurchaserGroupId() && matchingMsConfigBean.getPurchaserGroupId()>0) {
                    //购方集团有值且不相等，该中规则配置不使用

                    logger.info("AR---购方集团有值且不相等，该中规则配置不使用 configId:{}--msConfigBeanFromBill:{}",matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId(), JsonUtils.writeObjectToFastJson(msConfigBeanFromBill));
                    continue;
                }

                //购方公司匹配得分
                if(!StringUtils.isEmpty(matchingMsConfigBean.getPurchaserTaxNo()) && matchingMsConfigBean.getPurchaserTaxNo().equals(msConfigBeanFromBill.getPurchaserTaxNo())) {
                    score += 160;
                }else if(!StringUtils.isEmpty(matchingMsConfigBean.getPurchaserTaxNo())) {
                    //购方公司有值 且 不相等、该中规则配置不使用
                    logger.info("AR---购方公司有值 且 不相等、该中规则配置不使用 configId:{}",matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId());
                    continue;
                }

                //创建方式AR +1 分
                score += 1;
            }
            //AP创建
            else {
                //购方集团Id匹配得分
                if (null !=matchingMsConfigBean.getPurchaserGroupId() && matchingMsConfigBean.getPurchaserGroupId() > 0 && matchingMsConfigBean.getPurchaserGroupId().equals(msConfigBeanFromBill.getPurchaserGroupId())) {
                    score += 2;
                }else {
                    //购方集团Id 不相等，放弃本次的匹配规则， 按筛选条件，不可能运行到该分支
                    logger.info("AP---购方集团Id 不相等，放弃本次的匹配规则， 按筛选条件，不可能运行到该分支 configId:{}",matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId());
                    continue;
                }

                //销方公司匹配得分
                if (!StringUtils.isEmpty(matchingMsConfigBean.getPurchaserTaxNo()) && matchingMsConfigBean.getPurchaserTaxNo().equals(msConfigBeanFromBill.getPurchaserTaxNo())) {
                    score += 160;
                }else if (!StringUtils.isEmpty(matchingMsConfigBean.getPurchaserTaxNo())){
                    //销方集团Id相等、公司有值且不相等：该规则不使用
                    logger.info("AP---销方集团Id相等、公司有值且不相等：该规则不使用 configId:{}",matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId());
                    continue;
                }

                //购、销方子组织匹配得分
                /*if (!StringUtils.isEmpty(matchingMsConfigBean.getExt1()) && matchingMsConfigBean.getExt1().equals(msConfigBeanFromBill.getExt1()) ) {
                    score += 170;
                } else if(!StringUtils.isEmpty(matchingMsConfigBean.getExt1())) {
                    //购方集团Id相等、公司有值且相等、子组织有值且不相等：该规则不使用
                    logger.info("AP---购方集团Id相等、公司有值且相等、子组织有值且不相等：该规则不使用 configId:{}",matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId());
                    continue;
                }*/

                //销方集团匹配得分
                if (null != matchingMsConfigBean.getSellerGroupId() && matchingMsConfigBean.getSellerGroupId()>0 && matchingMsConfigBean.getSellerGroupId().equals(msConfigBeanFromBill.getSellerGroupId())) {
                    score += 2;
                }else if(null != matchingMsConfigBean.getSellerGroupId() && matchingMsConfigBean.getSellerGroupId()>0) {
                    //销方集团有值且不相等，该中规则配置不使用
                    logger.info("AP---销方集团有值且不相等，该中规则配置不使用 configId:{}",matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId());
                    continue;
                }

                //销方公司匹配得分
                if(!StringUtils.isEmpty(matchingMsConfigBean.getSellerTaxNo()) && matchingMsConfigBean.getSellerTaxNo().equals(msConfigBeanFromBill.getSellerTaxNo())) {
                    score += 160;
                }else if(!StringUtils.isEmpty(matchingMsConfigBean.getSellerTaxNo())) {
                    logger.info("AP---购方公司有值 且 不相等、该中规则配置不使用 configId:{}",matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId());
                    //购方公司有值 且 不相等、该中规则配置不使用
                    continue;
                }
            }

            //购、销方 业务类型匹配得分
            if (!StringUtils.isEmpty(matchingMsConfigBean.getSalesbillType()) && matchingMsConfigBean.getSalesbillType().equals(msConfigBeanFromBill.getSalesbillType())) {
                score += 4;
            }else if (!StringUtils.isEmpty(matchingMsConfigBean.getSalesbillType())){
                //销方集团Id相等、公司有值且相等、子组织有值且相等、 业务类型有值且不等：该规则不使用
                logger.info("ARAP---销方集团Id相等、公司有值且相等、子组织有值且相等、 业务类型有值且不等：该规则不使用 configId:{}",matchingMsConfigBean == null ? null : matchingMsConfigBean.getConfigId());
                continue;
            }

            //购、销方 扩展属性匹配得分
            score += getScoreByExtFields(matchingMsConfigBean, msConfigBeanFromBill);

            logger.info("matched====total size:{}, configId:{}, score:{} : AR|AP:{}",targetMsConfigBeanList.size(), matchingMsConfigBean.getConfigId(), score, matchingMsConfigBean.getBusinessBillType());
            if (score > maxScore) {
                maxScore = score;
                retMsConfigBean = matchingMsConfigBean;
            }
        }
        logger.info("splitConfigRuleMatch--- match result retMsConfigBean===>:{}", JsonUtils.writeObjectToFastJson(retMsConfigBean));
        return retMsConfigBean;
    }

}
