package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel(description = "【零售】销方信息")
@JsonInclude(NON_NULL)
@Data
public class ConfigIssueSellerInfoDTO {

    @ApiModelProperty("销方税号")
    @JsonProperty("sellerTaxNo")
    private String sellerTaxNo;

    @ApiModelProperty("销方名称")
    @JsonProperty("sellerName")
    private String sellerName;

    @ApiModelProperty("销方地址")
    @JsonProperty("sellerAddress")
    private String sellerAddress;

    @ApiModelProperty("销方电话")
    @JsonProperty("sellerTel")
    private String sellerTel;

    @ApiModelProperty("销方银行账户")
    @JsonProperty("sellerBankAccount")
    private String sellerBankAccount;

    @ApiModelProperty("销方银行名称")
    @JsonProperty("sellerBankName")
    private String sellerBankName;

}
