package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel(description = "【零售】开票人信息")
@JsonInclude(NON_NULL)
@Data
public class ConfigIssueUserInfoDTO {

    @ApiModelProperty("开票人")
    @JsonProperty("invoicerName")
    private String invoicerName;

    @ApiModelProperty("收款人")
    @JsonProperty("cashierName")
    private String cashierName;

    @ApiModelProperty("复核人")
    @JsonProperty("checkerName")
    private String checkerName;

}
