package com.xforceplus.seller.config.client.model;/**
 * Created by admin on 2018/10/23.
 */

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * @Author zzw
 * @Description
 * @Date
 * @return
 **/
@ApiModel(description = "配置数据包含元素原始值及当前值")
@JsonInclude(NON_NULL)
public class ConifgItemDataDTO {
    //字典key
    @ApiModelProperty("配置项名称：发票限额 invoiceLimit")
    @JsonProperty("itemName")
    private String itemName;
    // 字典项值
    @ApiModelProperty("配置项中文名称")
    @JsonProperty("itemDisplayName")
    private String itemDisplayName;
    @ApiModelProperty("表示 配置项相等关系的值单选或文本值{code,value,text} 对于多选值 [{code,value,text}]")
    @JsonProperty("value")
    private List<String> value;
    @ApiModelProperty("表示 配置项最大值 ")
    @JsonProperty("max")
    private String max;
    @ApiModelProperty("表示 配置项最小值 ")
    @JsonProperty("min")
    private String min;
    @ApiModelProperty("所属主配置ID ")
    @JsonProperty("configId")
    private Long configId;
    @ApiModelProperty("配置项位置  ")
    @JsonProperty("sort")
    private Byte sort;
    @ApiModelProperty("原始配置枚举[{code,value,text}]")
    @JsonProperty("enumValueList")
    private List<MsEnumBean> enumValueList;
    @ApiModelProperty("是否是多选类型")
    @JsonProperty("isMulti")
    private Integer isMulti;
    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemDisplayName() {
        return itemDisplayName;
    }

    public void setItemDisplayName(String itemDisplayName) {
        this.itemDisplayName = itemDisplayName;
    }

    public List<String> getValue() {
        return value;
    }

    public void setValue(List<String> value) {
        this.value = value;
    }

    public String getMax() {
        return max;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public String getMin() {
        return min;
    }

    public void setMin(String min) {
        this.min = min;
    }

    public Long getConfigId() {
        return configId;
    }

    public void setConfigId(Long configId) {
        this.configId = configId;
    }

    public Byte getSort() {
        return sort;
    }

    public void setSort(Byte sort) {
        this.sort = sort;
    }

    public List<MsEnumBean> getEnumValueList() {
        return enumValueList;
    }

    public void setEnumValueList(List<MsEnumBean> enumValueList) {
        this.enumValueList = enumValueList;
    }

    public Integer getIsMulti() {
        return isMulti;
    }

    public void setIsMulti(Integer isMulti) {
        this.isMulti = isMulti;
    }
}
