package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): wangjingshuang
 * 创建日期:      2020年12月28日11:41:45
 */
@Data
@ApiModel(description = "排序字段对象")
@JsonInclude(NON_NULL)
public class CustomSorter {

    @JsonProperty("fieldName")
    @ApiModelProperty(value = "字段名称")
    private String fieldName;

    @JsonProperty("fieldDescription")
    @ApiModelProperty(value = "字段描述")
    private String fieldDescription;

    @JsonProperty("fieldOrder")
    @ApiModelProperty(value = "字段升降序：0-升序，1-降序")
    private String fieldOrder;

    @JsonProperty("fieldOrdinal")
    @ApiModelProperty(value = "序数")
    private Integer fieldOrdinal;
}
