package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsAcquireLicenseResult {
  @JsonProperty("licenseUrl")
  private String licenseUrl = null;

  @JsonIgnore
  public MsAcquireLicenseResult licenseUrl(String licenseUrl) {
    this.licenseUrl = licenseUrl;
    return this;
  }

   /**
   * 授权文件下载地址
   * @return licenseUrl
  **/
  @ApiModelProperty(value = "授权文件下载地址")
  public String getLicenseUrl() {
    return licenseUrl;
  }

  public void setLicenseUrl(String licenseUrl) {
    this.licenseUrl = licenseUrl;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAcquireLicenseResult acquireLicenseResult = (MsAcquireLicenseResult) o;
    return Objects.equals(this.licenseUrl, acquireLicenseResult.licenseUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(licenseUrl);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAcquireLicenseResult {\n");
    
    sb.append("    licenseUrl: ").append(toIndentedString(licenseUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
