package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsEnumBean;
import com.xforceplus.seller.config.client.model.MsHighlightBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsBusinessObjMetadataBean {
  @JsonProperty("businessObjMetadataId")
  private Long businessObjMetadataId = null;

  @JsonProperty("businessObjId")
  private Long businessObjId = null;

  @JsonProperty("fieldName")
  private String fieldName = null;

  @JsonProperty("fieldDisplayName")
  private String fieldDisplayName = null;

  @JsonProperty("fieldGroup")
  private String fieldGroup = null;

  @JsonProperty("fieldGroupName")
  private String fieldGroupName = null;

  @JsonProperty("fieldGroupIndex")
  private Integer fieldGroupIndex = null;

  @JsonProperty("fieldRequired")
  private Integer fieldRequired = 0;

  @JsonProperty("fieldType")
  private String fieldType = null;

  @JsonProperty("fieldQueryType")
  private String fieldQueryType = null;

  @JsonProperty("fieldEnumValue")
  private List<MsEnumBean> fieldEnumValue = new ArrayList<MsEnumBean>();

  @JsonProperty("fieldHighlightValue")
  private List<MsHighlightBean> fieldHighlightValue = new ArrayList<MsHighlightBean>();

  @JsonProperty("fieldLength")
  private Integer fieldLength = null;

  @JsonProperty("fieldSort")
  private Integer fieldSort = null;

  @JsonProperty("fieldGridRow")
  private Integer fieldGridRow = null;

  @JsonProperty("fieldGridColumn")
  private Integer fieldGridColumn = null;

  @JsonProperty("fieldVisible")
  private Integer fieldVisible = 1;

  @JsonProperty("fieldReadonly")
  private Integer fieldReadonly = 0;

  @JsonProperty("displayType")
  private String displayType = null;

  @JsonProperty("associativeUrl")
  private String associativeUrl = null;

  @JsonProperty("virtual")
  private Integer virtual = 0;

  @JsonProperty("fixed")
  private Integer fixed = 1;

  @JsonProperty("fixedUpdate")
  private Integer fixedUpdate = 1;

  @JsonProperty("commonUsed")
  private Integer commonUsed=1;


  @JsonProperty("fieldDefaultValue")
  private List<String> fieldDefaultValue = new ArrayList<String>();

  @JsonIgnore
  public MsBusinessObjMetadataBean businessObjMetadataId(Long businessObjMetadataId) {
    this.businessObjMetadataId = businessObjMetadataId;
    return this;
  }

  /**
   * 是否常用
   * @return businessObjMetadataId
   **/
  @ApiModelProperty(value = "是否常用")
  public Integer getCommonUsed() {
    return commonUsed;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean setCommonUsed(Integer commonUsed) {
    this.commonUsed = commonUsed;
    return  this;
  }

  /**
   * 主键字段
   * @return businessObjMetadataId
  **/
  @ApiModelProperty(value = "主键字段")
  public Long getBusinessObjMetadataId() {
    return businessObjMetadataId;
  }

  public void setBusinessObjMetadataId(Long businessObjMetadataId) {
    this.businessObjMetadataId = businessObjMetadataId;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean businessObjId(Long businessObjId) {
    this.businessObjId = businessObjId;
    return this;
  }

   /**
   * 业务对象主键
   * @return businessObjId
  **/
  @ApiModelProperty(value = "业务对象主键")
  public Long getBusinessObjId() {
    return businessObjId;
  }

  public void setBusinessObjId(Long businessObjId) {
    this.businessObjId = businessObjId;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fieldName(String fieldName) {
    this.fieldName = fieldName;
    return this;
  }

   /**
   * 字段名  标准数据库字段 或 cfg_config 扩展字段
   * @return fieldName
  **/
  @ApiModelProperty(value = "字段名  标准数据库字段 或 cfg_config 扩展字段")
  public String getFieldName() {
    return fieldName;
  }

  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fieldDisplayName(String fieldDisplayName) {
    this.fieldDisplayName = fieldDisplayName;
    return this;
  }

   /**
   * 字段中文名称
   * @return fieldDisplayName
  **/
  @ApiModelProperty(value = "字段中文名称")
  public String getFieldDisplayName() {
    return fieldDisplayName;
  }

  public void setFieldDisplayName(String fieldDisplayName) {
    this.fieldDisplayName = fieldDisplayName;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fieldGroup(String fieldGroup) {
    this.fieldGroup = fieldGroup;
    return this;
  }

   /**
   * 字段分组
   * @return fieldGroup
  **/
  @ApiModelProperty(value = "字段分组")
  public String getFieldGroup() {
    return fieldGroup;
  }

  public void setFieldGroup(String fieldGroup) {
    this.fieldGroup = fieldGroup;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fieldGroupName(String fieldGroupName) {
    this.fieldGroupName = fieldGroupName;
    return this;
  }

   /**
   * 字段分组名称
   * @return fieldGroupName
  **/
  @ApiModelProperty(value = "字段分组名称")
  public String getFieldGroupName() {
    return fieldGroupName;
  }

  public void setFieldGroupName(String fieldGroupName) {
    this.fieldGroupName = fieldGroupName;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fieldGroupIndex(Integer fieldGroupIndex) {
    this.fieldGroupIndex = fieldGroupIndex;
    return this;
  }

   /**
   * 分组索引编号
   * @return fieldGroupIndex
  **/
  @ApiModelProperty(value = "分组索引编号")
  public Integer getFieldGroupIndex() {
    return fieldGroupIndex;
  }

  public void setFieldGroupIndex(Integer fieldGroupIndex) {
    this.fieldGroupIndex = fieldGroupIndex;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fieldRequired(Integer fieldRequired) {
    this.fieldRequired = fieldRequired;
    return this;
  }

   /**
   * Get fieldRequired
   * @return fieldRequired
  **/
  @ApiModelProperty(value = "")
  public Integer getFieldRequired() {
    return fieldRequired;
  }

  public void setFieldRequired(Integer fieldRequired) {
    this.fieldRequired = fieldRequired;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fieldType(String fieldType) {
    this.fieldType = fieldType;
    return this;
  }

   /**
   * s 文本 n 数值 d 日期  t 时间   l 联想
   * @return fieldType
  **/
  @ApiModelProperty(value = "s 文本 n 数值 d 日期(年月日)  m: 月份（年月）, t 时间(年月日 时分秒)   l 联想  f 多行文本")
  public String getFieldType() {
    return fieldType;
  }

  public void setFieldType(String fieldType) {
    this.fieldType = fieldType;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fieldQueryType(String fieldQueryType) {
    this.fieldQueryType = fieldQueryType;
    return this;
  }

   /**
   * eq：精确  like：模糊 rang：范围 checkbox：枚举复选 radio：枚举单选
   * @return fieldQueryType
  **/
  @ApiModelProperty(value = "eq：精确  like：模糊 rang：范围 checkbox：枚举复选 radio：枚举单选")
  public String getFieldQueryType() {
    return fieldQueryType;
  }

  public void setFieldQueryType(String fieldQueryType) {
    this.fieldQueryType = fieldQueryType;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fieldEnumValue(List<MsEnumBean> fieldEnumValue) {
    this.fieldEnumValue = fieldEnumValue;
    return this;
  }

  public MsBusinessObjMetadataBean addFieldEnumValueItem(MsEnumBean fieldEnumValueItem) {
    this.fieldEnumValue.add(fieldEnumValueItem);
    return this;
  }

   /**
   * 
   * @return fieldEnumValue
  **/
  @ApiModelProperty(value = "")
  public List<MsEnumBean> getFieldEnumValue() {
    return fieldEnumValue;
  }

  public void setFieldEnumValue(List<MsEnumBean> fieldEnumValue) {
    this.fieldEnumValue = fieldEnumValue;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fieldHighlightValue(List<MsHighlightBean> fieldHighlightValue) {
    this.fieldHighlightValue = fieldHighlightValue;
    return this;
  }

  public MsBusinessObjMetadataBean addFieldHighlightValueItem(MsHighlightBean fieldHighlightValueItem) {
    this.fieldHighlightValue.add(fieldHighlightValueItem);
    return this;
  }

   /**
   * 字段需要高亮显示条件
   * @return fieldHighlightValue
  **/
  @ApiModelProperty(value = "字段需要高亮显示条件")
  public List<MsHighlightBean> getFieldHighlightValue() {
    return fieldHighlightValue;
  }

  public void setFieldHighlightValue(List<MsHighlightBean> fieldHighlightValue) {
    this.fieldHighlightValue = fieldHighlightValue;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fieldLength(Integer fieldLength) {
    this.fieldLength = fieldLength;
    return this;
  }

   /**
   * 字段长度
   * @return fieldLength
  **/
  @ApiModelProperty(value = "字段长度")
  public Integer getFieldLength() {
    return fieldLength;
  }

  public void setFieldLength(Integer fieldLength) {
    this.fieldLength = fieldLength;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fieldSort(Integer fieldSort) {
    this.fieldSort = fieldSort;
    return this;
  }

   /**
   * 排序标识
   * @return fieldSort
  **/
  @ApiModelProperty(value = "排序标识")
  public Integer getFieldSort() {
    return fieldSort;
  }

  public void setFieldSort(Integer fieldSort) {
    this.fieldSort = fieldSort;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fieldGridRow(Integer fieldGridRow) {
    this.fieldGridRow = fieldGridRow;
    return this;
  }

   /**
   * 行号
   * @return fieldGridRow
  **/
  @ApiModelProperty(value = "行号")
  public Integer getFieldGridRow() {
    return fieldGridRow;
  }

  public void setFieldGridRow(Integer fieldGridRow) {
    this.fieldGridRow = fieldGridRow;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fieldGridColumn(Integer fieldGridColumn) {
    this.fieldGridColumn = fieldGridColumn;
    return this;
  }

   /**
   * 列号
   * @return fieldGridColumn
  **/
  @ApiModelProperty(value = "列号")
  public Integer getFieldGridColumn() {
    return fieldGridColumn;
  }

  public void setFieldGridColumn(Integer fieldGridColumn) {
    this.fieldGridColumn = fieldGridColumn;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fieldVisible(Integer fieldVisible) {
    this.fieldVisible = fieldVisible;
    return this;
  }

   /**
   * Get fieldVisible
   * @return fieldVisible
  **/
  @ApiModelProperty(value = "")
  public Integer getFieldVisible() {
    return fieldVisible;
  }

  public void setFieldVisible(Integer fieldVisible) {
    this.fieldVisible = fieldVisible;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fieldReadonly(Integer fieldReadonly) {
    this.fieldReadonly = fieldReadonly;
    return this;
  }

   /**
   * 只读属性 1  true  0 false 默认为 0
   * @return fieldReadonly
  **/
  @ApiModelProperty(value = "只读属性 1  true  0 false 默认为 0")
  public Integer getFieldReadonly() {
    return fieldReadonly;
  }

  public void setFieldReadonly(Integer fieldReadonly) {
    this.fieldReadonly = fieldReadonly;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean displayType(String displayType) {
    this.displayType = displayType;
    return this;
  }

   /**
   * 显示格式(1 文本框; 2-下拉框  3-复选框 4 单选 )
   * @return displayType
  **/
  @ApiModelProperty(value = "显示格式(1 文本框; 2-下拉框  3-复选框 4 单选 )")
  public String getDisplayType() {
    return displayType;
  }

  public void setDisplayType(String displayType) {
    this.displayType = displayType;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean associativeUrl(String associativeUrl) {
    this.associativeUrl = associativeUrl;
    return this;
  }

   /**
   * 联想URL(对应FIELD_QUERY_TYPE=6)
   * @return associativeUrl
  **/
  @ApiModelProperty(value = "联想URL(对应FIELD_QUERY_TYPE=6)")
  public String getAssociativeUrl() {
    return associativeUrl;
  }

  public void setAssociativeUrl(String associativeUrl) {
    this.associativeUrl = associativeUrl;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean virtual(Integer virtual) {
    this.virtual = virtual;
    return this;
  }

   /**
   * 1 表示虚拟字段 0 非虚拟字段
   * @return virtual
  **/
  @ApiModelProperty(value = "1 表示虚拟字段 0 非虚拟字段")
  public Integer getVirtual() {
    return virtual;
  }

  public void setVirtual(Integer virtual) {
    this.virtual = virtual;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fixed(Integer fixed) {
    this.fixed = fixed;
    return this;
  }

   /**
   * 1:是 0 否
   * @return fixed
  **/
  @ApiModelProperty(value = "1:是 0 否")
  public Integer getFixed() {
    return fixed;
  }

  public void setFixed(Integer fixed) {
    this.fixed = fixed;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fixedUpdate(Integer fixedUpdate) {
    this.fixedUpdate = fixedUpdate;
    return this;
  }

   /**
   * 是否可以修改 1:是 0 否
   * @return fixedUpdate
  **/
  @ApiModelProperty(value = "是否可以修改 1:是 0 否")
  public Integer getFixedUpdate() {
    return fixedUpdate;
  }

  public void setFixedUpdate(Integer fixedUpdate) {
    this.fixedUpdate = fixedUpdate;
  }

  @JsonIgnore
  public MsBusinessObjMetadataBean fieldDefaultValue(List<String> fieldDefaultValue) {
    this.fieldDefaultValue = fieldDefaultValue;
    return this;
  }

  public MsBusinessObjMetadataBean addFieldDefaultValueItem(String fieldDefaultValueItem) {
    this.fieldDefaultValue.add(fieldDefaultValueItem);
    return this;
  }

   /**
   * 默认值
   * @return fieldDefaultValue
  **/
  @ApiModelProperty(value = "默认值")
  public List<String> getFieldDefaultValue() {
    return fieldDefaultValue;
  }

  public void setFieldDefaultValue(List<String> fieldDefaultValue) {
    this.fieldDefaultValue = fieldDefaultValue;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBusinessObjMetadataBean businessObjMetadataBean = (MsBusinessObjMetadataBean) o;
    return Objects.equals(this.businessObjMetadataId, businessObjMetadataBean.businessObjMetadataId) &&
        Objects.equals(this.businessObjId, businessObjMetadataBean.businessObjId) &&
        Objects.equals(this.fieldName, businessObjMetadataBean.fieldName) &&
        Objects.equals(this.fieldDisplayName, businessObjMetadataBean.fieldDisplayName) &&
        Objects.equals(this.fieldGroup, businessObjMetadataBean.fieldGroup) &&
        Objects.equals(this.fieldGroupName, businessObjMetadataBean.fieldGroupName) &&
        Objects.equals(this.fieldGroupIndex, businessObjMetadataBean.fieldGroupIndex) &&
        Objects.equals(this.fieldRequired, businessObjMetadataBean.fieldRequired) &&
        Objects.equals(this.fieldType, businessObjMetadataBean.fieldType) &&
        Objects.equals(this.fieldQueryType, businessObjMetadataBean.fieldQueryType) &&
        Objects.equals(this.fieldEnumValue, businessObjMetadataBean.fieldEnumValue) &&
        Objects.equals(this.fieldHighlightValue, businessObjMetadataBean.fieldHighlightValue) &&
        Objects.equals(this.fieldLength, businessObjMetadataBean.fieldLength) &&
        Objects.equals(this.fieldSort, businessObjMetadataBean.fieldSort) &&
        Objects.equals(this.fieldGridRow, businessObjMetadataBean.fieldGridRow) &&
        Objects.equals(this.fieldGridColumn, businessObjMetadataBean.fieldGridColumn) &&
        Objects.equals(this.fieldVisible, businessObjMetadataBean.fieldVisible) &&
        Objects.equals(this.fieldReadonly, businessObjMetadataBean.fieldReadonly) &&
        Objects.equals(this.displayType, businessObjMetadataBean.displayType) &&
        Objects.equals(this.associativeUrl, businessObjMetadataBean.associativeUrl) &&
        Objects.equals(this.virtual, businessObjMetadataBean.virtual) &&
        Objects.equals(this.fixed, businessObjMetadataBean.fixed) &&
        Objects.equals(this.fixedUpdate, businessObjMetadataBean.fixedUpdate) &&
        Objects.equals(this.fieldDefaultValue, businessObjMetadataBean.fieldDefaultValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessObjMetadataId, businessObjId, fieldName, fieldDisplayName, fieldGroup, fieldGroupName, fieldGroupIndex, fieldRequired, fieldType, fieldQueryType, fieldEnumValue, fieldHighlightValue, fieldLength, fieldSort, fieldGridRow, fieldGridColumn, fieldVisible, fieldReadonly, displayType, associativeUrl, virtual, fixed, fixedUpdate, fieldDefaultValue);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBusinessObjMetadataBean {\n");
    
    sb.append("    businessObjMetadataId: ").append(toIndentedString(businessObjMetadataId)).append("\n");
    sb.append("    businessObjId: ").append(toIndentedString(businessObjId)).append("\n");
    sb.append("    fieldName: ").append(toIndentedString(fieldName)).append("\n");
    sb.append("    fieldDisplayName: ").append(toIndentedString(fieldDisplayName)).append("\n");
    sb.append("    fieldGroup: ").append(toIndentedString(fieldGroup)).append("\n");
    sb.append("    fieldGroupName: ").append(toIndentedString(fieldGroupName)).append("\n");
    sb.append("    fieldGroupIndex: ").append(toIndentedString(fieldGroupIndex)).append("\n");
    sb.append("    fieldRequired: ").append(toIndentedString(fieldRequired)).append("\n");
    sb.append("    fieldType: ").append(toIndentedString(fieldType)).append("\n");
    sb.append("    fieldQueryType: ").append(toIndentedString(fieldQueryType)).append("\n");
    sb.append("    fieldEnumValue: ").append(toIndentedString(fieldEnumValue)).append("\n");
    sb.append("    fieldHighlightValue: ").append(toIndentedString(fieldHighlightValue)).append("\n");
    sb.append("    fieldLength: ").append(toIndentedString(fieldLength)).append("\n");
    sb.append("    fieldSort: ").append(toIndentedString(fieldSort)).append("\n");
    sb.append("    fieldGridRow: ").append(toIndentedString(fieldGridRow)).append("\n");
    sb.append("    fieldGridColumn: ").append(toIndentedString(fieldGridColumn)).append("\n");
    sb.append("    fieldVisible: ").append(toIndentedString(fieldVisible)).append("\n");
    sb.append("    fieldReadonly: ").append(toIndentedString(fieldReadonly)).append("\n");
    sb.append("    displayType: ").append(toIndentedString(displayType)).append("\n");
    sb.append("    associativeUrl: ").append(toIndentedString(associativeUrl)).append("\n");
    sb.append("    virtual: ").append(toIndentedString(virtual)).append("\n");
    sb.append("    fixed: ").append(toIndentedString(fixed)).append("\n");
    sb.append("    fixedUpdate: ").append(toIndentedString(fixedUpdate)).append("\n");
    sb.append("    fieldDefaultValue: ").append(toIndentedString(fieldDefaultValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
