package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 用户自定义导出字段
 */
@ApiModel(description = "用户自定义导出字段")

@JsonInclude(NON_NULL)
public class MsCfgBusinessObjMetaInfo {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("businessObjMetadataId")
  private Long businessObjMetadataId = null;

  @JsonProperty("businessObjId")
  private Long businessObjId = null;

  @JsonProperty("fieldName")
  private String fieldName = null;

  @JsonProperty("fieldDisplayName")
  private String fieldDisplayName = null;

  @JsonProperty("fieldGroup")
  private String fieldGroup = null;

  @JsonProperty("fieldGroupName")
  private String fieldGroupName = null;

  @JsonProperty("fieldGroupIndex")
  private Integer fieldGroupIndex = null;

  @JsonProperty("fieldRequired")
  private Integer fieldRequired = null;

  @JsonProperty("fieldType")
  private String fieldType = null;

  @JsonProperty("fieldQueryType")
  private String fieldQueryType = null;

  @JsonProperty("fieldEnumValue")
  private String fieldEnumValue = null;

  @JsonProperty("fieldDefaultValue")
  private String fieldDefaultValue = null;

  @JsonProperty("fieldLength")
  private Integer fieldLength = null;

  @JsonProperty("fieldSort")
  private Integer fieldSort = null;

  @JsonProperty("fieldGridRow")
  private Integer fieldGridRow = null;

  @JsonProperty("fieldGridColumn")
  private Integer fieldGridColumn = null;

  @JsonProperty("fieldVisible")
  private Integer fieldVisible = null;

  @JsonProperty("fieldReadonly")
  private Integer fieldReadonly = null;

  @JsonProperty("displayType")
  private String displayType = null;

  @JsonProperty("associativeUrl")
  private String associativeUrl = null;

  @JsonProperty("virtual")
  private Integer virtual = null;

  @JsonProperty("fixed")
  private Integer fixed = null;

  @JsonProperty("fixedUpdate")
  private Integer fixedUpdate = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("createUser")
  private Long createUser = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonProperty("updateUser")
  private Long updateUser = null;

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键id
   * @return id
  **/
  @ApiModelProperty(value = "主键id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo businessObjMetadataId(Long businessObjMetadataId) {
    this.businessObjMetadataId = businessObjMetadataId;
    return this;
  }

   /**
   * 元数据主键
   * @return businessObjMetadataId
  **/
  @ApiModelProperty(value = "元数据主键")
  public Long getBusinessObjMetadataId() {
    return businessObjMetadataId;
  }

  public void setBusinessObjMetadataId(Long businessObjMetadataId) {
    this.businessObjMetadataId = businessObjMetadataId;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo businessObjId(Long businessObjId) {
    this.businessObjId = businessObjId;
    return this;
  }

   /**
   * 业务对象主键
   * @return businessObjId
  **/
  @ApiModelProperty(value = "业务对象主键")
  public Long getBusinessObjId() {
    return businessObjId;
  }

  public void setBusinessObjId(Long businessObjId) {
    this.businessObjId = businessObjId;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo fieldName(String fieldName) {
    this.fieldName = fieldName;
    return this;
  }

   /**
   * 标准数据库字段，或 cfg_config 扩展字段
   * @return fieldName
  **/
  @ApiModelProperty(value = "标准数据库字段，或 cfg_config 扩展字段")
  public String getFieldName() {
    return fieldName;
  }

  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo fieldDisplayName(String fieldDisplayName) {
    this.fieldDisplayName = fieldDisplayName;
    return this;
  }

   /**
   * 字段中文名称
   * @return fieldDisplayName
  **/
  @ApiModelProperty(value = "字段中文名称")
  public String getFieldDisplayName() {
    return fieldDisplayName;
  }

  public void setFieldDisplayName(String fieldDisplayName) {
    this.fieldDisplayName = fieldDisplayName;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo fieldGroup(String fieldGroup) {
    this.fieldGroup = fieldGroup;
    return this;
  }

   /**
   * 字段分组
   * @return fieldGroup
  **/
  @ApiModelProperty(value = "字段分组")
  public String getFieldGroup() {
    return fieldGroup;
  }

  public void setFieldGroup(String fieldGroup) {
    this.fieldGroup = fieldGroup;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo fieldGroupName(String fieldGroupName) {
    this.fieldGroupName = fieldGroupName;
    return this;
  }

   /**
   * 字段分组名称
   * @return fieldGroupName
  **/
  @ApiModelProperty(value = "字段分组名称")
  public String getFieldGroupName() {
    return fieldGroupName;
  }

  public void setFieldGroupName(String fieldGroupName) {
    this.fieldGroupName = fieldGroupName;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo fieldGroupIndex(Integer fieldGroupIndex) {
    this.fieldGroupIndex = fieldGroupIndex;
    return this;
  }

   /**
   * 分组索引编号 bill:0 、 billitem:1
   * @return fieldGroupIndex
  **/
  @ApiModelProperty(value = "分组索引编号 bill:0 、 billitem:1")
  public Integer getFieldGroupIndex() {
    return fieldGroupIndex;
  }

  public void setFieldGroupIndex(Integer fieldGroupIndex) {
    this.fieldGroupIndex = fieldGroupIndex;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo fieldRequired(Integer fieldRequired) {
    this.fieldRequired = fieldRequired;
    return this;
  }

   /**
   * 1:必填 0：非必填
   * @return fieldRequired
  **/
  @ApiModelProperty(value = "1:必填 0：非必填")
  public Integer getFieldRequired() {
    return fieldRequired;
  }

  public void setFieldRequired(Integer fieldRequired) {
    this.fieldRequired = fieldRequired;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo fieldType(String fieldType) {
    this.fieldType = fieldType;
    return this;
  }

   /**
   * s-文本 n-数值 d-日期  t-时间   l-联想
   * @return fieldType
  **/
  @ApiModelProperty(value = "s-文本 n-数值 d-日期  t-时间   l-联想")
  public String getFieldType() {
    return fieldType;
  }

  public void setFieldType(String fieldType) {
    this.fieldType = fieldType;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo fieldQueryType(String fieldQueryType) {
    this.fieldQueryType = fieldQueryType;
    return this;
  }

   /**
   * eq-精确  like-模糊 rang-范围 checkbox-枚举复选 radio-枚举单选
   * @return fieldQueryType
  **/
  @ApiModelProperty(value = "eq-精确  like-模糊 rang-范围 checkbox-枚举复选 radio-枚举单选")
  public String getFieldQueryType() {
    return fieldQueryType;
  }

  public void setFieldQueryType(String fieldQueryType) {
    this.fieldQueryType = fieldQueryType;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo fieldEnumValue(String fieldEnumValue) {
    this.fieldEnumValue = fieldEnumValue;
    return this;
  }

   /**
   * json数据-格式code-value-text
   * @return fieldEnumValue
  **/
  @ApiModelProperty(value = "json数据-格式code-value-text")
  public String getFieldEnumValue() {
    return fieldEnumValue;
  }

  public void setFieldEnumValue(String fieldEnumValue) {
    this.fieldEnumValue = fieldEnumValue;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo fieldDefaultValue(String fieldDefaultValue) {
    this.fieldDefaultValue = fieldDefaultValue;
    return this;
  }

   /**
   * 字段默认值
   * @return fieldDefaultValue
  **/
  @ApiModelProperty(value = "字段默认值")
  public String getFieldDefaultValue() {
    return fieldDefaultValue;
  }

  public void setFieldDefaultValue(String fieldDefaultValue) {
    this.fieldDefaultValue = fieldDefaultValue;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo fieldLength(Integer fieldLength) {
    this.fieldLength = fieldLength;
    return this;
  }

   /**
   * 字段长度
   * @return fieldLength
  **/
  @ApiModelProperty(value = "字段长度")
  public Integer getFieldLength() {
    return fieldLength;
  }

  public void setFieldLength(Integer fieldLength) {
    this.fieldLength = fieldLength;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo fieldSort(Integer fieldSort) {
    this.fieldSort = fieldSort;
    return this;
  }

   /**
   * 排序标识
   * @return fieldSort
  **/
  @ApiModelProperty(value = "排序标识")
  public Integer getFieldSort() {
    return fieldSort;
  }

  public void setFieldSort(Integer fieldSort) {
    this.fieldSort = fieldSort;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo fieldGridRow(Integer fieldGridRow) {
    this.fieldGridRow = fieldGridRow;
    return this;
  }

   /**
   * 行号
   * @return fieldGridRow
  **/
  @ApiModelProperty(value = "行号")
  public Integer getFieldGridRow() {
    return fieldGridRow;
  }

  public void setFieldGridRow(Integer fieldGridRow) {
    this.fieldGridRow = fieldGridRow;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo fieldGridColumn(Integer fieldGridColumn) {
    this.fieldGridColumn = fieldGridColumn;
    return this;
  }

   /**
   * 列号
   * @return fieldGridColumn
  **/
  @ApiModelProperty(value = "列号")
  public Integer getFieldGridColumn() {
    return fieldGridColumn;
  }

  public void setFieldGridColumn(Integer fieldGridColumn) {
    this.fieldGridColumn = fieldGridColumn;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo fieldVisible(Integer fieldVisible) {
    this.fieldVisible = fieldVisible;
    return this;
  }

   /**
   * 1-显示 0-不显示
   * @return fieldVisible
  **/
  @ApiModelProperty(value = "1-显示 0-不显示")
  public Integer getFieldVisible() {
    return fieldVisible;
  }

  public void setFieldVisible(Integer fieldVisible) {
    this.fieldVisible = fieldVisible;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo fieldReadonly(Integer fieldReadonly) {
    this.fieldReadonly = fieldReadonly;
    return this;
  }

   /**
   * 只读属性 1- true  0-false 默认为 0
   * @return fieldReadonly
  **/
  @ApiModelProperty(value = "只读属性 1- true  0-false 默认为 0")
  public Integer getFieldReadonly() {
    return fieldReadonly;
  }

  public void setFieldReadonly(Integer fieldReadonly) {
    this.fieldReadonly = fieldReadonly;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo displayType(String displayType) {
    this.displayType = displayType;
    return this;
  }

   /**
   * 显示格式(1-文本框; 2-下拉框; 3-复选框 4-单选 )
   * @return displayType
  **/
  @ApiModelProperty(value = "显示格式(1-文本框; 2-下拉框; 3-复选框 4-单选 )")
  public String getDisplayType() {
    return displayType;
  }

  public void setDisplayType(String displayType) {
    this.displayType = displayType;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo associativeUrl(String associativeUrl) {
    this.associativeUrl = associativeUrl;
    return this;
  }

   /**
   * 联想URL(对应FIELD_QUERY_TYPE=6)
   * @return associativeUrl
  **/
  @ApiModelProperty(value = "联想URL(对应FIELD_QUERY_TYPE=6)")
  public String getAssociativeUrl() {
    return associativeUrl;
  }

  public void setAssociativeUrl(String associativeUrl) {
    this.associativeUrl = associativeUrl;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo virtual(Integer virtual) {
    this.virtual = virtual;
    return this;
  }

   /**
   * 虚拟字段 0 主表 1 其他表 2 字表
   * @return virtual
  **/
  @ApiModelProperty(value = "虚拟字段 0 主表 1 其他表 2 字表")
  public Integer getVirtual() {
    return virtual;
  }

  public void setVirtual(Integer virtual) {
    this.virtual = virtual;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo fixed(Integer fixed) {
    this.fixed = fixed;
    return this;
  }

   /**
   * 1-是 固定 0-否 扩展字段
   * @return fixed
  **/
  @ApiModelProperty(value = "1-是 固定 0-否 扩展字段")
  public Integer getFixed() {
    return fixed;
  }

  public void setFixed(Integer fixed) {
    this.fixed = fixed;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo fixedUpdate(Integer fixedUpdate) {
    this.fixedUpdate = fixedUpdate;
    return this;
  }

   /**
   * 是否可以修改，控制前段业务单类型管理的修改字段的 1可以修改 0否不可以修改
   * @return fixedUpdate
  **/
  @ApiModelProperty(value = "是否可以修改，控制前段业务单类型管理的修改字段的 1可以修改 0否不可以修改")
  public Integer getFixedUpdate() {
    return fixedUpdate;
  }

  public void setFixedUpdate(Integer fixedUpdate) {
    this.fixedUpdate = fixedUpdate;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo createUser(Long createUser) {
    this.createUser = createUser;
    return this;
  }

   /**
   * 创建人
   * @return createUser
  **/
  @ApiModelProperty(value = "创建人")
  public Long getCreateUser() {
    return createUser;
  }

  public void setCreateUser(Long createUser) {
    this.createUser = createUser;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  @JsonIgnore
  public MsCfgBusinessObjMetaInfo updateUser(Long updateUser) {
    this.updateUser = updateUser;
    return this;
  }

   /**
   * 更新人
   * @return updateUser
  **/
  @ApiModelProperty(value = "更新人")
  public Long getUpdateUser() {
    return updateUser;
  }

  public void setUpdateUser(Long updateUser) {
    this.updateUser = updateUser;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCfgBusinessObjMetaInfo cfgBusinessObjMetaInfo = (MsCfgBusinessObjMetaInfo) o;
    return Objects.equals(this.id, cfgBusinessObjMetaInfo.id) &&
        Objects.equals(this.businessObjMetadataId, cfgBusinessObjMetaInfo.businessObjMetadataId) &&
        Objects.equals(this.businessObjId, cfgBusinessObjMetaInfo.businessObjId) &&
        Objects.equals(this.fieldName, cfgBusinessObjMetaInfo.fieldName) &&
        Objects.equals(this.fieldDisplayName, cfgBusinessObjMetaInfo.fieldDisplayName) &&
        Objects.equals(this.fieldGroup, cfgBusinessObjMetaInfo.fieldGroup) &&
        Objects.equals(this.fieldGroupName, cfgBusinessObjMetaInfo.fieldGroupName) &&
        Objects.equals(this.fieldGroupIndex, cfgBusinessObjMetaInfo.fieldGroupIndex) &&
        Objects.equals(this.fieldRequired, cfgBusinessObjMetaInfo.fieldRequired) &&
        Objects.equals(this.fieldType, cfgBusinessObjMetaInfo.fieldType) &&
        Objects.equals(this.fieldQueryType, cfgBusinessObjMetaInfo.fieldQueryType) &&
        Objects.equals(this.fieldEnumValue, cfgBusinessObjMetaInfo.fieldEnumValue) &&
        Objects.equals(this.fieldDefaultValue, cfgBusinessObjMetaInfo.fieldDefaultValue) &&
        Objects.equals(this.fieldLength, cfgBusinessObjMetaInfo.fieldLength) &&
        Objects.equals(this.fieldSort, cfgBusinessObjMetaInfo.fieldSort) &&
        Objects.equals(this.fieldGridRow, cfgBusinessObjMetaInfo.fieldGridRow) &&
        Objects.equals(this.fieldGridColumn, cfgBusinessObjMetaInfo.fieldGridColumn) &&
        Objects.equals(this.fieldVisible, cfgBusinessObjMetaInfo.fieldVisible) &&
        Objects.equals(this.fieldReadonly, cfgBusinessObjMetaInfo.fieldReadonly) &&
        Objects.equals(this.displayType, cfgBusinessObjMetaInfo.displayType) &&
        Objects.equals(this.associativeUrl, cfgBusinessObjMetaInfo.associativeUrl) &&
        Objects.equals(this.virtual, cfgBusinessObjMetaInfo.virtual) &&
        Objects.equals(this.fixed, cfgBusinessObjMetaInfo.fixed) &&
        Objects.equals(this.fixedUpdate, cfgBusinessObjMetaInfo.fixedUpdate) &&
        Objects.equals(this.createTime, cfgBusinessObjMetaInfo.createTime) &&
        Objects.equals(this.createUser, cfgBusinessObjMetaInfo.createUser) &&
        Objects.equals(this.updateTime, cfgBusinessObjMetaInfo.updateTime) &&
        Objects.equals(this.updateUser, cfgBusinessObjMetaInfo.updateUser);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, businessObjMetadataId, businessObjId, fieldName, fieldDisplayName, fieldGroup, fieldGroupName, fieldGroupIndex, fieldRequired, fieldType, fieldQueryType, fieldEnumValue, fieldDefaultValue, fieldLength, fieldSort, fieldGridRow, fieldGridColumn, fieldVisible, fieldReadonly, displayType, associativeUrl, virtual, fixed, fixedUpdate, createTime, createUser, updateTime, updateUser);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCfgBusinessObjMetaInfo {\n");

    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    businessObjMetadataId: ").append(toIndentedString(businessObjMetadataId)).append("\n");
    sb.append("    businessObjId: ").append(toIndentedString(businessObjId)).append("\n");
    sb.append("    fieldName: ").append(toIndentedString(fieldName)).append("\n");
    sb.append("    fieldDisplayName: ").append(toIndentedString(fieldDisplayName)).append("\n");
    sb.append("    fieldGroup: ").append(toIndentedString(fieldGroup)).append("\n");
    sb.append("    fieldGroupName: ").append(toIndentedString(fieldGroupName)).append("\n");
    sb.append("    fieldGroupIndex: ").append(toIndentedString(fieldGroupIndex)).append("\n");
    sb.append("    fieldRequired: ").append(toIndentedString(fieldRequired)).append("\n");
    sb.append("    fieldType: ").append(toIndentedString(fieldType)).append("\n");
    sb.append("    fieldQueryType: ").append(toIndentedString(fieldQueryType)).append("\n");
    sb.append("    fieldEnumValue: ").append(toIndentedString(fieldEnumValue)).append("\n");
    sb.append("    fieldDefaultValue: ").append(toIndentedString(fieldDefaultValue)).append("\n");
    sb.append("    fieldLength: ").append(toIndentedString(fieldLength)).append("\n");
    sb.append("    fieldSort: ").append(toIndentedString(fieldSort)).append("\n");
    sb.append("    fieldGridRow: ").append(toIndentedString(fieldGridRow)).append("\n");
    sb.append("    fieldGridColumn: ").append(toIndentedString(fieldGridColumn)).append("\n");
    sb.append("    fieldVisible: ").append(toIndentedString(fieldVisible)).append("\n");
    sb.append("    fieldReadonly: ").append(toIndentedString(fieldReadonly)).append("\n");
    sb.append("    displayType: ").append(toIndentedString(displayType)).append("\n");
    sb.append("    associativeUrl: ").append(toIndentedString(associativeUrl)).append("\n");
    sb.append("    virtual: ").append(toIndentedString(virtual)).append("\n");
    sb.append("    fixed: ").append(toIndentedString(fixed)).append("\n");
    sb.append("    fixedUpdate: ").append(toIndentedString(fixedUpdate)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    createUser: ").append(toIndentedString(createUser)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    updateUser: ").append(toIndentedString(updateUser)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
