package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsConfigAddRequest {
  @JsonProperty("itemDTOList")
  private List<MsConfigBean> itemDTOList = new ArrayList<MsConfigBean>();

  @JsonIgnore
  public MsConfigAddRequest itemDTOList(List<MsConfigBean> itemDTOList) {
    this.itemDTOList = itemDTOList;
    return this;
  }

  public MsConfigAddRequest addItemDTOListItem(MsConfigBean itemDTOListItem) {
    this.itemDTOList.add(itemDTOListItem);
    return this;
  }

   /**
   * Get itemDTOList
   * @return itemDTOList
  **/
  @ApiModelProperty(value = "")
  public List<MsConfigBean> getItemDTOList() {
    return itemDTOList;
  }

  public void setItemDTOList(List<MsConfigBean> itemDTOList) {
    this.itemDTOList = itemDTOList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigAddRequest configAddRequest = (MsConfigAddRequest) o;
    return Objects.equals(this.itemDTOList, configAddRequest.itemDTOList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(itemDTOList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigAddRequest {\n");
    
    sb.append("    itemDTOList: ").append(toIndentedString(itemDTOList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
