package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsConfigAddRequestWithUserInfo {
  @JsonProperty("itemDTOList")
  private List<MsConfigBean> itemDTOList = new ArrayList<MsConfigBean>();

  @JsonProperty("userInfo")
  private MsCommonUserInfo userInfo = null;

  @JsonIgnore
  public MsConfigAddRequestWithUserInfo itemDTOList(List<MsConfigBean> itemDTOList) {
    this.itemDTOList = itemDTOList;
    return this;
  }

  public MsConfigAddRequestWithUserInfo addItemDTOListItem(MsConfigBean itemDTOListItem) {
    this.itemDTOList.add(itemDTOListItem);
    return this;
  }

   /**
   * Get itemDTOList
   * @return itemDTOList
  **/
  @ApiModelProperty(value = "")
  public List<MsConfigBean> getItemDTOList() {
    return itemDTOList;
  }

  public void setItemDTOList(List<MsConfigBean> itemDTOList) {
    this.itemDTOList = itemDTOList;
  }

  @JsonIgnore
  public MsConfigAddRequestWithUserInfo userInfo(MsCommonUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * 用户信息
   * @return userInfo
  **/
  @ApiModelProperty(value = "用户信息")
  public MsCommonUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsCommonUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigAddRequestWithUserInfo configAddRequestWithUserInfo = (MsConfigAddRequestWithUserInfo) o;
    return Objects.equals(this.itemDTOList, configAddRequestWithUserInfo.itemDTOList) &&
        Objects.equals(this.userInfo, configAddRequestWithUserInfo.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(itemDTOList, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigAddRequestWithUserInfo {\n");
    
    sb.append("    itemDTOList: ").append(toIndentedString(itemDTOList)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
