package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsDeviceInfo;
import com.xforceplus.seller.config.client.model.MsLicenseInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsConfigDeviceAddRequest
 */

@JsonInclude(NON_NULL)
public class MsConfigDeviceAddRequest {
  @JsonProperty("licenseInfo")
  private MsLicenseInfo licenseInfo = null;

  @JsonProperty("deviceInfo")
  private MsDeviceInfo deviceInfo = null;

  @JsonIgnore
  public MsConfigDeviceAddRequest licenseInfo(MsLicenseInfo licenseInfo) {
    this.licenseInfo = licenseInfo;
    return this;
  }

   /**
   * 终端授权信息,可选
   * @return licenseInfo
  **/
  @ApiModelProperty(value = "终端授权信息,可选")
  public MsLicenseInfo getLicenseInfo() {
    return licenseInfo;
  }

  public void setLicenseInfo(MsLicenseInfo licenseInfo) {
    this.licenseInfo = licenseInfo;
  }

  @JsonIgnore
  public MsConfigDeviceAddRequest deviceInfo(MsDeviceInfo deviceInfo) {
    this.deviceInfo = deviceInfo;
    return this;
  }

   /**
   * 设备的信息
   * @return deviceInfo
  **/
  @ApiModelProperty(value = "设备的信息")
  public MsDeviceInfo getDeviceInfo() {
    return deviceInfo;
  }

  public void setDeviceInfo(MsDeviceInfo deviceInfo) {
    this.deviceInfo = deviceInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigDeviceAddRequest configDeviceAddRequest = (MsConfigDeviceAddRequest) o;
    return Objects.equals(this.licenseInfo, configDeviceAddRequest.licenseInfo) &&
        Objects.equals(this.deviceInfo, configDeviceAddRequest.deviceInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(licenseInfo, deviceInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigDeviceAddRequest {\n");
    
    sb.append("    licenseInfo: ").append(toIndentedString(licenseInfo)).append("\n");
    sb.append("    deviceInfo: ").append(toIndentedString(deviceInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
