package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsCompanyModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsConfigDeviceGetCompanyListResponse
 */

@JsonInclude(NON_NULL)
public class MsConfigDeviceGetCompanyListResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private List<MsCompanyModel> result = new ArrayList<MsCompanyModel>();

  @JsonIgnore
  public MsConfigDeviceGetCompanyListResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 返回结果状态（1：成功 0：失败）
   * @return code
  **/
  @ApiModelProperty(value = "返回结果状态（1：成功 0：失败）")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsConfigDeviceGetCompanyListResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * 返回信息
   * @return message
  **/
  @ApiModelProperty(value = "返回信息")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsConfigDeviceGetCompanyListResponse result(List<MsCompanyModel> result) {
    this.result = result;
    return this;
  }

  public MsConfigDeviceGetCompanyListResponse addResultItem(MsCompanyModel resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 设置税控设备获取公司列表对象返回结果内容
   * @return result
  **/
  @ApiModelProperty(value = "设置税控设备获取公司列表对象返回结果内容")
  public List<MsCompanyModel> getResult() {
    return result;
  }

  public void setResult(List<MsCompanyModel> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigDeviceGetCompanyListResponse configDeviceGetCompanyListResponse = (MsConfigDeviceGetCompanyListResponse) o;
    return Objects.equals(this.code, configDeviceGetCompanyListResponse.code) &&
        Objects.equals(this.message, configDeviceGetCompanyListResponse.message) &&
        Objects.equals(this.result, configDeviceGetCompanyListResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigDeviceGetCompanyListResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
