package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsConfigItemTempBean {
  @JsonProperty("configItemId")
  private Long configItemId = null;

  @JsonProperty("configId")
  private Long configId = null;

  @JsonProperty("configItemName")
  private String configItemName = null;

  @JsonProperty("configItemDisplayName")
  private String configItemDisplayName = null;

  @JsonProperty("configItemValue")
  private List<String> configItemValue = new ArrayList<String>();

  @JsonIgnore
  public MsConfigItemTempBean configItemId(Long configItemId) {
    this.configItemId = configItemId;
    return this;
  }

   /**
   * null
   * @return configItemId
  **/
  @ApiModelProperty(value = "null")
  public Long getConfigItemId() {
    return configItemId;
  }

  public void setConfigItemId(Long configItemId) {
    this.configItemId = configItemId;
  }

  @JsonIgnore
  public MsConfigItemTempBean configId(Long configId) {
    this.configId = configId;
    return this;
  }

   /**
   * 配置项id
   * @return configId
  **/
  @ApiModelProperty(value = "配置项id")
  public Long getConfigId() {
    return configId;
  }

  public void setConfigId(Long configId) {
    this.configId = configId;
  }

  @JsonIgnore
  public MsConfigItemTempBean configItemName(String configItemName) {
    this.configItemName = configItemName;
    return this;
  }

   /**
   * 字段名称 billNo ext1 等 \"taxDeviceType\",
   * @return configItemName
  **/
  @ApiModelProperty(value = "字段名称 billNo ext1 等 \"taxDeviceType\",")
  public String getConfigItemName() {
    return configItemName;
  }

  public void setConfigItemName(String configItemName) {
    this.configItemName = configItemName;
  }

  @JsonIgnore
  public MsConfigItemTempBean configItemDisplayName(String configItemDisplayName) {
    this.configItemDisplayName = configItemDisplayName;
    return this;
  }

   /**
   * 中文名称
   * @return configItemDisplayName
  **/
  @ApiModelProperty(value = "中文名称")
  public String getConfigItemDisplayName() {
    return configItemDisplayName;
  }

  public void setConfigItemDisplayName(String configItemDisplayName) {
    this.configItemDisplayName = configItemDisplayName;
  }

  @JsonIgnore
  public MsConfigItemTempBean configItemValue(List<String> configItemValue) {
    this.configItemValue = configItemValue;
    return this;
  }

  public MsConfigItemTempBean addConfigItemValueItem(String configItemValueItem) {
    this.configItemValue.add(configItemValueItem);
    return this;
  }

   /**
   * json方式描述配置项判断规则
   * @return configItemValue
  **/
  @ApiModelProperty(value = "json方式描述配置项判断规则")
  public List<String> getConfigItemValue() {
    return configItemValue;
  }

  public void setConfigItemValue(List<String> configItemValue) {
    this.configItemValue = configItemValue;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigItemTempBean configItemTempBean = (MsConfigItemTempBean) o;
    return Objects.equals(this.configItemId, configItemTempBean.configItemId) &&
        Objects.equals(this.configId, configItemTempBean.configId) &&
        Objects.equals(this.configItemName, configItemTempBean.configItemName) &&
        Objects.equals(this.configItemDisplayName, configItemTempBean.configItemDisplayName) &&
        Objects.equals(this.configItemValue, configItemTempBean.configItemValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configItemId, configId, configItemName, configItemDisplayName, configItemValue);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigItemTempBean {\n");
    
    sb.append("    configItemId: ").append(toIndentedString(configItemId)).append("\n");
    sb.append("    configId: ").append(toIndentedString(configId)).append("\n");
    sb.append("    configItemName: ").append(toIndentedString(configItemName)).append("\n");
    sb.append("    configItemDisplayName: ").append(toIndentedString(configItemDisplayName)).append("\n");
    sb.append("    configItemValue: ").append(toIndentedString(configItemValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
