package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel(description = "MsConfigMailRule")

@JsonInclude(NON_NULL)
@Data
public class MsConfigMailRule {
    /** 邮件推送规则id */
    Long configMailRuleId;

    /** 规则id */
    Long configId;

    // 自动发送
    @JsonProperty("autosend")
    boolean autosend = false;

    // 通知类型 邮件
    @JsonProperty("noticeType")
    String noticeType = "mail";

    // 邮件模板ID
    @JsonProperty("mailTemplateNo")
    String mailTemplateNo = null;

    // 从业务单拉取邮箱
    @JsonProperty("pickBizBillAddress")
    boolean pickBizBillAddress = true;

    // 从用户中心客单拉取邮箱
    @JsonProperty("pickUCAddress")
    boolean pickUCAddress = false;

    // 使用自定义邮箱
    @JsonProperty("useCustomAddress")
    boolean useCustomAddress = true;

    // 自定义邮箱列表
    @JsonProperty("customMailList")
    String customMailList = null;

    // 立即发送
    @JsonProperty("sendAtOnce")
    boolean sendAtOnce = false;

    // 每天发送
    @JsonProperty("sendDaily")
    boolean sendDaily = false;

    // 发送时间 HH:mm
    @JsonProperty("sendTime")
    String sendTime = "00:00";

    // 合并类型 AP购方 AP 销方 ALL 全部合并 NONE 不合并
    @JsonProperty("combineType")
    String combineType = "AP";

    @JsonProperty("sendMonthly")
    // 默认每月1号凌晨2点任务
    boolean sendMonthly = false;

    // 默认每月1号凌晨2点任务
    @JsonProperty("monthSendTime")
    String monthSendTime = "00:00";

    // 默认每月1号凌晨2点任务
    @JsonProperty("monthCombineType")
    String monthCombineType = "AP";

}
