package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsConfigTemialAuthQueryRequest
 */

@JsonInclude(NON_NULL)
public class MsConfigTemialAuthQueryRequest {
  @JsonProperty("supportService")
  private List<String> supportService = new ArrayList<String>();

  @JsonProperty("invoiceType")
  private List<String> invoiceType = new ArrayList<String>();

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo;

  @JsonProperty("taxNos")
  private List<String> taxNos;

  @JsonIgnore
  public MsConfigTemialAuthQueryRequest supportService(List<String> supportService) {
    this.supportService = supportService;
    return this;
  }

  public MsConfigTemialAuthQueryRequest addSupportServiceItem(String supportServiceItem) {
    this.supportService.add(supportServiceItem);
    return this;
  }

   /**
   * 支持的服务
   * @return supportService
  **/
  @ApiModelProperty(value = "支持的服务")
  public List<String> getSupportService() {
    return supportService;
  }

  public void setSupportService(List<String> supportService) {
    this.supportService = supportService;
  }

  @JsonIgnore
  public MsConfigTemialAuthQueryRequest invoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

  public MsConfigTemialAuthQueryRequest addInvoiceTypeItem(String invoiceTypeItem) {
    this.invoiceType.add(invoiceTypeItem);
    return this;
  }

   /**
   * 发票类型
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型")
  public List<String> getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
  }

  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @ApiModelProperty(value = "销方税号集合")
  public List<String> getTaxNos() {
    return taxNos;
  }

  public void setTaxNos(List<String> taxNos) {
    this.taxNos = taxNos;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigTemialAuthQueryRequest configTemialAuthQueryRequest = (MsConfigTemialAuthQueryRequest) o;
    return Objects.equals(this.supportService, configTemialAuthQueryRequest.supportService) &&
        Objects.equals(this.invoiceType, configTemialAuthQueryRequest.invoiceType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(supportService, invoiceType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigTemialAuthQueryRequest {\n");
    
    sb.append("    supportService: ").append(toIndentedString(supportService)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
