package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsTerminalQueryInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsConfigTemialQueryMakeOutRequest
 */

@JsonInclude(NON_NULL)
public class MsConfigTemialQueryMakeOutRequest {
  @JsonProperty("terminalInfo")
  private MsTerminalQueryInfo terminalInfo = null;

  @JsonIgnore
  public MsConfigTemialQueryMakeOutRequest terminalInfo(MsTerminalQueryInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
    return this;
  }

   /**
   * 终端信息
   * @return terminalInfo
  **/
  @ApiModelProperty(value = "终端信息")
  public MsTerminalQueryInfo getTerminalInfo() {
    return terminalInfo;
  }

  public void setTerminalInfo(MsTerminalQueryInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigTemialQueryMakeOutRequest configTemialQueryMakeOutRequest = (MsConfigTemialQueryMakeOutRequest) o;
    return Objects.equals(this.terminalInfo, configTemialQueryMakeOutRequest.terminalInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(terminalInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigTemialQueryMakeOutRequest {\n");
    
    sb.append("    terminalInfo: ").append(toIndentedString(terminalInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
