package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsConfigTitleSummaryResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private List<MsConfigTitleSummaryDTO> result = new ArrayList<MsConfigTitleSummaryDTO>();

  @JsonIgnore
  public MsConfigTitleSummaryResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 发起 1表示已受理 -1表示调用失败 查询 1表示处理完成 2表示处理中
   * @return code
  **/
  @ApiModelProperty(value = "发起 1表示已受理 -1表示调用失败 查询 1表示处理完成 2表示处理中")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsConfigTitleSummaryResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsConfigTitleSummaryResponse result(List<MsConfigTitleSummaryDTO> result) {
    this.result = result;
    return this;
  }

  public MsConfigTitleSummaryResponse addResultItem(MsConfigTitleSummaryDTO resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 发起 1表示已受理 -1表示调用失败 查询 1表示处理完成 2表示处理中
   * @return result
  **/
  @ApiModelProperty(value = "发起 1表示已受理 -1表示调用失败 查询 1表示处理完成 2表示处理中")
  public List<MsConfigTitleSummaryDTO> getResult() {
    return result;
  }

  public void setResult(List<MsConfigTitleSummaryDTO> result) {
    this.result = result;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigTitleSummaryResponse configSummaryResponse = (MsConfigTitleSummaryResponse) o;
    return Objects.equals(this.code, configSummaryResponse.code) &&
        Objects.equals(this.message, configSummaryResponse.message) &&
        Objects.equals(this.result, configSummaryResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigSummaryResponse {\n");

    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
