package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 设备的信息
 */
@ApiModel(description = "设备的信息")

@JsonInclude(NON_NULL)
public class MsDeviceQueryInfo {
  @JsonProperty("deviceType")
  private String deviceType = null;

  @JsonProperty("deviceIds")
  private List<Long> deviceIds = new ArrayList<Long>();

  @JsonProperty("deviceUns")
  private List<String> deviceUns = new ArrayList<>();

  @JsonProperty("companyInfo")
  private MsCompanyQueryInfo companyInfo = null;

  @JsonProperty("deviceNo")
  private String deviceNo = null;

  @JsonProperty("deviceName")
  private String deviceName = null;

  @JsonProperty("supportService")
  private List<String> supportService = new ArrayList<String>();

  @JsonProperty("status")
  private List<Integer> status = new ArrayList<Integer>();

  @JsonProperty("taxDeviceInfo")
  private MsTaxDeviceQueryRequestInfo taxDeviceInfo = null;

  public List<String> getDeviceUns() {
    return deviceUns;
  }

  public void setDeviceUns(List<String> deviceUns) {
    this.deviceUns = deviceUns;
  }

  @JsonIgnore
  public MsDeviceQueryInfo deviceType(String deviceType) {
    this.deviceType = deviceType;
    return this;
  }

   /**
   * （必须）设备类型，taxDevice：税控设备，UKey：UKey
   * @return deviceType
  **/
  @ApiModelProperty(value = "（必须）设备类型，taxDevice：税控设备，UKey：UKey")
  public String getDeviceType() {
    return deviceType;
  }

  public void setDeviceType(String deviceType) {
    this.deviceType = deviceType;
  }

  @JsonIgnore
  public MsDeviceQueryInfo deviceIds(List<Long> deviceIds) {
    this.deviceIds = deviceIds;
    return this;
  }

  public MsDeviceQueryInfo addDeviceIdsItem(Long deviceIdsItem) {
    this.deviceIds.add(deviceIdsItem);
    return this;
  }

   /**
   * 设备id
   * @return deviceIds
  **/
  @ApiModelProperty(value = "设备id")
  public List<Long> getDeviceIds() {
    return deviceIds;
  }

  public void setDeviceIds(List<Long> deviceIds) {
    this.deviceIds = deviceIds;
  }

  @JsonIgnore
  public MsDeviceQueryInfo companyInfo(MsCompanyQueryInfo companyInfo) {
    this.companyInfo = companyInfo;
    return this;
  }

   /**
   * 公司信息
   * @return companyInfo
  **/
  @ApiModelProperty(value = "公司信息")
  public MsCompanyQueryInfo getCompanyInfo() {
    return companyInfo;
  }

  public void setCompanyInfo(MsCompanyQueryInfo companyInfo) {
    this.companyInfo = companyInfo;
  }

  @JsonIgnore
  public MsDeviceQueryInfo deviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
    return this;
  }

   /**
   * 设备编号
   * @return deviceNo
  **/
  @ApiModelProperty(value = "设备编号")
  public String getDeviceNo() {
    return deviceNo;
  }

  public void setDeviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
  }

  @JsonIgnore
  public MsDeviceQueryInfo deviceName(String deviceName) {
    this.deviceName = deviceName;
    return this;
  }

   /**
   * 设备名称
   * @return deviceName
  **/
  @ApiModelProperty(value = "设备名称")
  public String getDeviceName() {
    return deviceName;
  }

  public void setDeviceName(String deviceName) {
    this.deviceName = deviceName;
  }

  @JsonIgnore
  public MsDeviceQueryInfo supportService(List<String> supportService) {
    this.supportService = supportService;
    return this;
  }

  public MsDeviceQueryInfo addSupportServiceItem(String supportServiceItem) {
    this.supportService.add(supportServiceItem);
    return this;
  }

   /**
   * 支持的服务（print:打印 make:开票,originAccount:底账）
   * @return supportService
  **/
  @ApiModelProperty(value = "支持的服务（print:打印 make:开票,originAccount:底账）")
  public List<String> getSupportService() {
    return supportService;
  }

  public void setSupportService(List<String> supportService) {
    this.supportService = supportService;
  }

  @JsonIgnore
  public MsDeviceQueryInfo status(List<Integer> status) {
    this.status = status;
    return this;
  }

  public MsDeviceQueryInfo addStatusItem(Integer statusItem) {
    this.status.add(statusItem);
    return this;
  }

   /**
   * 设备状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：停用）
   * @return status
  **/
  @ApiModelProperty(value = "设备状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：停用）")
  public List<Integer> getStatus() {
    return status;
  }

  public void setStatus(List<Integer> status) {
    this.status = status;
  }

  @JsonIgnore
  public MsDeviceQueryInfo taxDeviceInfo(MsTaxDeviceQueryRequestInfo taxDeviceInfo) {
    this.taxDeviceInfo = taxDeviceInfo;
    return this;
  }

   /**
   * 税控设备消息
   * @return taxDeviceInfo
  **/
  @ApiModelProperty(value = "税控设备消息")
  public MsTaxDeviceQueryRequestInfo getTaxDeviceInfo() {
    return taxDeviceInfo;
  }

  public void setTaxDeviceInfo(MsTaxDeviceQueryRequestInfo taxDeviceInfo) {
    this.taxDeviceInfo = taxDeviceInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsDeviceQueryInfo deviceQueryInfo = (MsDeviceQueryInfo) o;
    return Objects.equals(this.deviceType, deviceQueryInfo.deviceType) &&
        Objects.equals(this.deviceIds, deviceQueryInfo.deviceIds) &&
        Objects.equals(this.companyInfo, deviceQueryInfo.companyInfo) &&
        Objects.equals(this.deviceNo, deviceQueryInfo.deviceNo) &&
        Objects.equals(this.deviceName, deviceQueryInfo.deviceName) &&
        Objects.equals(this.supportService, deviceQueryInfo.supportService) &&
        Objects.equals(this.status, deviceQueryInfo.status) &&
        Objects.equals(this.taxDeviceInfo, deviceQueryInfo.taxDeviceInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deviceType, deviceIds, companyInfo, deviceNo, deviceName, supportService, status, taxDeviceInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsDeviceQueryInfo {\n");
    
    sb.append("    deviceType: ").append(toIndentedString(deviceType)).append("\n");
    sb.append("    deviceIds: ").append(toIndentedString(deviceIds)).append("\n");
    sb.append("    companyInfo: ").append(toIndentedString(companyInfo)).append("\n");
    sb.append("    deviceNo: ").append(toIndentedString(deviceNo)).append("\n");
    sb.append("    deviceName: ").append(toIndentedString(deviceName)).append("\n");
    sb.append("    supportService: ").append(toIndentedString(supportService)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    taxDeviceInfo: ").append(toIndentedString(taxDeviceInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
