package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsDeviceSummaryQueryResult
 */

@JsonInclude(NON_NULL)
public class MsDeviceSummaryQueryResult {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("count")
  private Long count = null;

  @JsonIgnore
  public MsDeviceSummaryQueryResult code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 状态代码
   * @return code
  **/
  @ApiModelProperty(value = "状态代码")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsDeviceSummaryQueryResult name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 名称
   * @return name
  **/
  @ApiModelProperty(value = "名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @JsonIgnore
  public MsDeviceSummaryQueryResult count(Long count) {
    this.count = count;
    return this;
  }

   /**
   * 数量
   * @return count
  **/
  @ApiModelProperty(value = "数量")
  public Long getCount() {
    return count;
  }

  public void setCount(Long count) {
    this.count = count;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsDeviceSummaryQueryResult deviceSummaryQueryResult = (MsDeviceSummaryQueryResult) o;
    return Objects.equals(this.code, deviceSummaryQueryResult.code) &&
        Objects.equals(this.name, deviceSummaryQueryResult.name) &&
        Objects.equals(this.count, deviceSummaryQueryResult.count);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, name, count);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsDeviceSummaryQueryResult {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
