package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsGroupTypeMetaDataDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 集团的下的业务类型，及业务类型下的所有元数据
 */
@ApiModel(description = "集团的下的业务类型，及业务类型下的所有元数据")

@JsonInclude(NON_NULL)
public class MsGroupTypeMetaDataResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private List<MsGroupTypeMetaDataDTO> result = new ArrayList<MsGroupTypeMetaDataDTO>();

  @JsonIgnore
  public MsGroupTypeMetaDataResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 发起 1表示已受理 -1表示调用失败 查询 1表示处理完成 2表示处理中
   * @return code
  **/
  @ApiModelProperty(value = "发起 1表示已受理 -1表示调用失败 查询 1表示处理完成 2表示处理中")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsGroupTypeMetaDataResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsGroupTypeMetaDataResponse result(List<MsGroupTypeMetaDataDTO> result) {
    this.result = result;
    return this;
  }

  public MsGroupTypeMetaDataResponse addResultItem(MsGroupTypeMetaDataDTO resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 返回对象,根据不同调用方法,返回的属性不一样
   * @return result
  **/
  @ApiModelProperty(value = "返回对象,根据不同调用方法,返回的属性不一样")
  public List<MsGroupTypeMetaDataDTO> getResult() {
    return result;
  }

  public void setResult(List<MsGroupTypeMetaDataDTO> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGroupTypeMetaDataResponse groupTypeMetaDataResponse = (MsGroupTypeMetaDataResponse) o;
    return Objects.equals(this.code, groupTypeMetaDataResponse.code) &&
        Objects.equals(this.message, groupTypeMetaDataResponse.message) &&
        Objects.equals(this.result, groupTypeMetaDataResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGroupTypeMetaDataResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
